/* AUTOGENERATED FROM bad-traffic_dga-detector.rules
alert udp $EXTERNAL_NET 53 -> $HOME_NET any (msg:"PROTOCOL-DNS domain not found containing random-looking hostname - possible DGA detected"; flow:to_client; content:"|81 83 00 01 00 00|"; offset:2; depth:6; metadata:service dns; classtype:trojan-activity; sid:31738;)
*/
/*
 * Copyright (C) 2005-2013 Sourcefire, Inc. All Rights Reserved
 *
 * This file may contain proprietary rules that were created, tested and
 * certified by Sourcefire, Inc. (the "VRT Certified Rules") as well as
 * rules that were created by Sourcefire and other third parties and
 * distributed under the GNU General Public License (the "GPL Rules").  The
 * VRT Certified Rules contained in this file are the property of
 * Sourcefire, Inc. Copyright 2005 Sourcefire, Inc. All Rights Reserved.
 * The GPL Rules created by Sourcefire, Inc. are the property of
 * Sourcefire, Inc. Copyright 2002-2005 Sourcefire, Inc. All Rights
 * Reserved.  All other GPL Rules are owned and copyrighted by their
 * respective owners (please see www.snort.org/contributors for a list of
 * owners and their respective copyrights).  In order to determine what
 * rules are VRT Certified Rules or GPL Rules, please refer to the VRT
 * Certified Rules License Agreement.
 */

//#define DEBUG
#ifdef DEBUG
#define DEBUG_SO(code) code
#else
#define DEBUG_SO(code)
#endif

#include <string.h>
#include <math.h>
#include <stdio.h>

#include "so-util_dns.h"
#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

#define MAX_SUBDOMAINS        6
#define MAX_GRAMS             3
#define RANDOM                1
#define NOT_RANDOM            0
#define OFFSET_TO_DOMAIN      4
#define MAX_SUBDOMAIN_LEN     63
#define MIN_SUBDOMAIN_LEN     7

#define MAX_SEGMENT_LEN       11
#define MAX_WHITELIST_ENTRIES 7
#define MAX_WHITELIST_SUBDOMAIN_LEN         12
#define MIN_WHITELIST_SUBDOMAIN_LEN         4

#define LENGTH_WEIGHT         1.5
#define RANDOMNESS_THRESHOLD  300
#define FUDGE_UNIGRAM         1
#define FUDGE_BIGRAM          20
#define FUDGE_TRIGRAM         500
#define FUDGE_QUADGRAM        3000
#define FUDGE_TOTAL           1000

const double powtable[5] = {1, 26, 676, 17576, 456976};

const char *white_list[MAX_SEGMENT_LEN+1][MAX_WHITELIST_ENTRIES] = {
/* Length = 0 */   { NULL },
/* Length = 1 */   { NULL },
/* Length = 2 */   { NULL },
/* Length = 3 */   { NULL },
/* Length = 4 */   { NULL },
/* Length = 5 */   { "adnxs", "aicdn", "llnwd", "local", "rlcdn", NULL },
/* Length = 6 */   { "akadns", "google", "rfihub", "belkin", "mcafee", "nuggad", NULL },
/* Length = 7 */   { "gstatic", "rackcdn", "wemfbox", "spcsdns", "youtube", NULL },
/* Length = 8 */   { "ad6media", "yahoodns", NULL },
/* Length = 9 */   { "amazonaws", "crwdcntrl", "accenture", NULL },
/* Length = 10 */  { "cloudflare", "cloudfront", NULL },
/* Length = 11 */  { "googlevideo", "archon-tech", NULL }
};

// n-gram tables.  Actual tables are at the end of this file.

double baseline_unigram[ /*26*/ ];
double baseline_bigram[ /*676*/ ];
double baseline_trigram[ /*17576*/ ];

double *baselines[] = { baseline_unigram, baseline_bigram, baseline_trigram};

/* declare detection functions */
int rule31738eval(void *p);
int lower_case(uint8_t *domain, uint32_t len);

/* declare rule data structures */
/* flow:to_client; */
static FlowFlags rule31738flow0 = 
{
   FLOW_TO_CLIENT
};

static RuleOption rule31738option0 =
{
   OPTION_TYPE_FLOWFLAGS,
   {
      &rule31738flow0
   }
};

// content:"|81 83 00 01 00 00|", offset 2, depth 6, fast_pattern; 
static ContentInfo rule31738content1 = 
{
   (uint8_t *) "|81 83 00 01 00 00|", /* pattern */
   6, /* depth */
   2, /* offset */
   CONTENT_FAST_PATTERN|CONTENT_BUF_NORMALIZED, /* flags */
   NULL, /* holder for boyer/moore PTR */
   NULL, /* more holder info - byteform */
   0, /* byteform length */
   0 /* increment length*/
};

static RuleOption rule31738option1 = 
{
   OPTION_TYPE_CONTENT,
   {
      &rule31738content1
   }
};

// pcre:"\d[-\x01\x02\x03]\d{1,3}[-\x01\x02\x03]\d{1,3}[-\x01\x02\x03]\d", relative;
static PCREInfo rule31738pcre2 =
{
   "\\d[-\\x01\\x02\\x03]\\d{1,3}[-\\x01\\x02\\x03]\\d{1,3}[-\\x01\\x02\\x03]\\d", /* pattern */
   NULL,                               /* holder for compiled pattern */
   NULL,                               /* holder for compiled pattern flags */
   0,     /* compile flags */
   CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED     /* content flags */
};

static RuleOption rule31738option2 =
{
   OPTION_TYPE_PCRE,
   {
      &rule31738pcre2
   }
};

/* references for sid 31738 */
static RuleReference *rule31738refs[] =
{
   NULL
};

/* metadata for sid 31738 */
/* metadata:service dns; */
static RuleMetaData rule31738service1 = 
{
   "service dns"
};

static RuleMetaData *rule31738metadata[] =
{
   &rule31738service1,
   NULL
};

RuleOption *rule31738options[] =
{
   &rule31738option0,
   &rule31738option1,
   &rule31738option2,
   NULL
};

Rule rule31738 = {
   /* rule header, akin to => tcp any any -> any any */
   {
      IPPROTO_UDP, /* proto */
      "$EXTERNAL_NET", /* SRCIP     */
      "53", /* SRCPORT   */
      0, /* DIRECTION */
      "$HOME_NET", /* DSTIP     */
      "any", /* DSTPORT   */
   },
   /* metadata */
   { 
      3,  /* genid */
      31738, /* sigid */
      2, /* revision */
      "trojan-activity", /* classification */
      0,  /* hardcoded priority */
      "PROTOCOL-DNS domain not found containing random-looking hostname - possible DGA detected",     /* message */
      rule31738refs, /* ptr to references */
      rule31738metadata /* ptr to metadata */
   },
   rule31738options, /* ptr to rule options */
   &rule31738eval, /* uncomment to use custom detection function */
   0 /* am I initialized yet? */
};

#ifdef DEBUG 
void print_dns_name(const uint8_t *entry) {
   uint8_t seglen;

   int i, j;

   i = 0;
   while(entry[i] != 0) {
      seglen = entry[i++];
      if((seglen & 0xC0) == 0xC0) { // is a pointer
         fprintf(stderr, "<p>");
         break;
      }

      for(j = 0; j < seglen; j++) {
         fprintf(stderr, "%c", entry[i++]);
      }

      if(entry[i] != 0) // No increment here; sets seglen above
         fprintf(stderr, ".");
      else
         break; // Redundant with loop conditional.  :shrug:
   };
   fprintf(stderr, "\n");
} 
#endif

int is_white_listed(uint8_t *domain, uint32_t len)
{
   uint32_t i = 0;

   // The ORIGINAL domain needs to go in here, not the reduced! 

   // Check if the domain segment is a UUID
   // Is it 36 bytes long?
   if(len == 36)
   {
       // Did we find dashes at 8, 13, 18, and 23
       if((domain[8] == '-') && (domain[13] == '-') && (domain[18] == '-') && (domain[23] == '-'))
           return 1;
   }

   if((len >= MIN_WHITELIST_SUBDOMAIN_LEN) && (len <= MAX_SEGMENT_LEN))
   {
      // Make the domain lowercase
      lower_case(domain, len);

      // Check if it starts with "xn--" (doing inline instead of memcmp to save time)
      if((domain[0] == 'x') && (domain[1] == 'n') && (domain[2] == '-') && (domain[3] == '-'))
         return 1;

      for(i = 0; white_list[len][i] != NULL; i++)
      {
         if(memcmp(domain, white_list[len][i], len) == 0)
         {
            return 1;
         }
      }
   }
   return 0;
}

int lower_case(uint8_t *domain, uint32_t len)
{
   uint32_t i = 0;

   for(i = 0; i < len; i++)
   {
       domain[i] = tolower(domain[i]);
   }

   return i;
}

int reduce_domain(uint8_t *domain, uint32_t len)
{
   uint32_t i = 0, j = 0;

   // Remove all non-alphabetic characters
   for(i = 0; i < len; i++)
   {
      // we only care about chars a-z (should already be lowercase)
      if((domain[i] >= 'a') && (domain[i] <= 'z'))
      {
         domain[j] = domain[i];
         j++;
      }
   }

   domain[j] = 0;
   len = j;

   return len;
}

double get_ngram_score(uint8_t *domain, uint32_t len, uint32_t grams)
{
   double   score = 0;
   double   p = 0;
   uint32_t x = 0;
   uint32_t i = 0;
   uint32_t j = 0;
   double   freq = 0;
   uint32_t freq_offset = 0;
   double   *ngram_baseline = baselines[grams-1];

   unsigned char cur_gram[MAX_GRAMS + 1] = {0};

   // Make sure we don't try to calculate more than MAX_GRAMS grams.
   if(grams > MAX_GRAMS)
       return 0;

   for(x = 0; x <= len-grams; x++)
   {
      // Get the current n-grams substring and store it in the "gram" array
      memcpy(cur_gram, &domain[x], grams);
      //DEBUG_SO(fprintf(stderr, "cur_gram: %c%c%c\n", cur_gram[0], cur_gram[1], cur_gram[2]);)
      // Get the location into the frequency array for the current gram
      j = grams - 1;
      freq_offset = 0;
      for(i = 0; i < grams; i++)
      {
         // minus 97 because lower case letters start at 97. ASCII
         //DEBUG_SO(fprintf(stderr, "\tj: %d\ti: %d\tgrams: %d\tcur_gram[i]: %c\n", j, i, grams, cur_gram[i]);)
         freq_offset += (powtable[j] * (cur_gram[i] - 97)); 
         j--;
      }

      //DEBUG_SO(fprintf(stderr, "\tfreq_offset: %d", freq_offset);)
      if(freq_offset > (powtable[grams] - 1))
      {
         //DEBUG_SO(fprintf(stderr, "\n** sizeof(baselines[grams]): %d **\n", (int)(pow(26,grams)-1));)
         return 0;
      }
      p = ngram_baseline[freq_offset];

      // I did this to save room in the header file
      // This isn't saving us any memory (just disk space) though 
      // so what's the point.
      //if(grams == 4)
      //    p /= 100000;

      if(p != 0)
      {
          score += (p * log(p));
      }
   }

   if(score != 0)
   {
      // Make sure our LENGTH_WEIGHT calculation never is zero
      p = pow(x, LENGTH_WEIGHT);
      if(p == 0.0)
         p = 1;

      score = -1 * (score / p);
   }

   return score;
}

int get_randomness_score(uint8_t *domain, uint32_t len)
{
   double    score = 0;

   score += get_ngram_score(domain, len, 1) * FUDGE_UNIGRAM;
   score += get_ngram_score(domain, len, 2) * FUDGE_BIGRAM;
   score += get_ngram_score(domain, len, 3) * FUDGE_TRIGRAM;
   //score += get_ngram_score(domain, len, 4) * FUDGE_QUADGRAM;
   score *= FUDGE_TOTAL;

   return score;
}

int is_random_domain(const uint8_t *domain, const uint8_t *end_of_buffer)
{
   uint8_t     domain_len = 0;
   uint8_t     subdomain_len = 0;
   uint8_t     subdomain[MAX_SUBDOMAIN_LEN + 1] = {0};
   uint32_t    is_random = 0;
   double      score = 0;
   uint32_t    x = 0;

   // Process the domain until we reach the end of the buffer for 
   // a maximum of MAX_SUBDOMAINS (max number of bytes to process 
   // is MAX_SUBDOMAINS * MAX_SUBDOMAIN_LEN)
   for(x = 0; x < MAX_SUBDOMAINS; x++)
   {
      // Check that we're not past the end of our buffer
      if(domain >= end_of_buffer)
         return NOT_RANDOM;

      // The length should be the first byte
      domain_len = domain[0];

      // The domain starts after the length
      domain += 1;

      // If the length is zero, we're done
      if(domain_len == 0) {
         return is_random;
      }

      // Make sure the length is less than the max allowed subdomain
      if(domain_len >= MAX_SUBDOMAIN_LEN) {
          return NOT_RANDOM;
      }

      // Check if we have at LEAST len bytes left in our buffer, else fail
      if(domain + domain_len > end_of_buffer)
         return NOT_RANDOM;

      // Zero out our entire subdomain buffer
      memset(subdomain, 0, sizeof(subdomain));
      // Copy the domain to our subdomain buffer
      memcpy(subdomain, domain, domain_len);

      // check if the domain is in our white list
      if(is_white_listed(subdomain, domain_len))
      {
         return NOT_RANDOM;
      }

      subdomain_len = reduce_domain(subdomain, domain_len);

      // We only deal with subdomains that have more than MIN_SUBDOMAIN_LEN characters after reduction
      if(subdomain_len >= MIN_SUBDOMAIN_LEN)
      {
         // send subdomain to get_randomness_score()
         score = get_randomness_score(subdomain, subdomain_len);

         if((score > 0) && (score < RANDOMNESS_THRESHOLD))
         {
            is_random = RANDOM;
         }
      }
      domain += domain_len;
   }

   return is_random;
}

/* detection functions */
int rule31738eval(void *p) {
   const uint8_t *cursor_normal = 0, *end_of_domain = 0, *beg_of_buffer, *end_of_buffer;
   SFSnortPacket *sp = (SFSnortPacket *) p;
   
   if(sp == NULL)
      return RULE_NOMATCH;

   if(sp->payload == NULL)
      return RULE_NOMATCH;
   
   // flow:to_client;
   if(checkFlow(p, rule31738options[0]->option_u.flowFlags) <= 0)
      return RULE_NOMATCH;
   
   // content:"|81 83 00 01 00 00|", offset 2, depth 6, fast_pattern;
   if(contentMatch(p, rule31738options[1]->option_u.content, &cursor_normal) <= 0)
      return RULE_NOMATCH;

   // Look for things that look like IP addresses in the hostname
   // Both "dots notation" (where the dots are actually dns length fields) and
   // dashes are supported.  ie "10.234.43.95" or "10-234-43-95"
   // pcre:"\d{1,3}[-\x01\x02\x03]\d{1,3}[-\x01\x02\x03]\d{1,3}[-\x01\x02\x03]\d{1,3}", relative;
   if(pcreMatch(p, rule31738options[2]->option_u.pcre, &cursor_normal) == RULE_MATCH)
      return RULE_NOMATCH;

   // Get the payload start and end 
   if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &beg_of_buffer, &end_of_buffer) <=0)
      return RULE_NOMATCH;

   // move to the domain   
   cursor_normal += OFFSET_TO_DOMAIN; 

   // Check that we have enough data before using the payload
   if(cursor_normal >= end_of_buffer)
       return RULE_NOMATCH;

   // Here, the end_of_domain var is actually the start of the domain...
   end_of_domain = cursor_normal;

   // dns_skip_name() moves end_of_domain from the start to the actual end here
   if(dns_skip_name(&end_of_domain, end_of_buffer) != DNS_SUCCESS)
      return RULE_NOMATCH;

   // Check if we have at LEAST 1 byte (the subdomain length) left in the buffer
   if((cursor_normal + 1) > end_of_domain)
      return RULE_NOMATCH;

   if(is_random_domain(cursor_normal, end_of_domain))
      return RULE_MATCH;
   else
      return RULE_NOMATCH;
}


// n-gram tables.  Declared above, defined here.

double baseline_unigram[ /*26*/ ] = 
{
	0.09300, 0.02400, 0.03800, 0.03300, 0.10600, 0.01700, 0.02500, 0.02500, 
	0.07500, 0.00500, 0.01800, 0.04900, 0.03500, 0.06200, 0.07600, 0.02800, 
	0.00200, 0.06900, 0.06800, 0.06400, 0.03400, 0.01300, 0.01300, 0.00500, 
	0.01700, 0.00600
};

double baseline_bigram[ /*676*/ ] = 
{
	0.00070, 0.00270, 0.00450, 0.00500, 0.00060, 0.00150, 0.00310, 0.00100, 
	0.00370, 0.00050, 0.00190, 0.01020, 0.00540, 0.01350, 0.00070, 0.00300, 
	0.00020, 0.01210, 0.00700, 0.00780, 0.00200, 0.00190, 0.00090, 0.00050, 
	0.00210, 0.00130, 0.00390, 0.00050, 0.00030, 0.00030, 0.00450, 0.00010, 
	0.00010, 0.00020, 0.00260, 0.00010, 0.00010, 0.00320, 0.00030, 0.00010, 
	0.00300, 0.00020, 0.00000, 0.00170, 0.00100, 0.00020, 0.00200, 0.00000, 
	0.00010, 0.00000, 0.00050, 0.00000, 0.00570, 0.00020, 0.00070, 0.00020, 
	0.00420, 0.00010, 0.00010, 0.00610, 0.00280, 0.00010, 0.00250, 0.00200, 
	0.00030, 0.00020, 0.00760, 0.00020, 0.00000, 0.00180, 0.00090, 0.00260, 
	0.00130, 0.00010, 0.00010, 0.00000, 0.00040, 0.00010, 0.00390, 0.00050, 
	0.00060, 0.00070, 0.00760, 0.00040, 0.00050, 0.00030, 0.00600, 0.00010, 
	0.00010, 0.00050, 0.00060, 0.00040, 0.00330, 0.00090, 0.00000, 0.00140, 
	0.00190, 0.00050, 0.00120, 0.00040, 0.00040, 0.00000, 0.00060, 0.00010, 
	0.00590, 0.00350, 0.00600, 0.00470, 0.00370, 0.00140, 0.00190, 0.00090, 
	0.00190, 0.00040, 0.00120, 0.00670, 0.00400, 0.01010, 0.00180, 0.00230, 
	0.00020, 0.01770, 0.01310, 0.00710, 0.00110, 0.00170, 0.00240, 0.00230, 
	0.00120, 0.00060, 0.00230, 0.00010, 0.00020, 0.00010, 0.00190, 0.00100, 
	0.00010, 0.00010, 0.00290, 0.00000, 0.00000, 0.00080, 0.00020, 0.00010, 
	0.00310, 0.00010, 0.00000, 0.00180, 0.00030, 0.00100, 0.00100, 0.00000, 
	0.00010, 0.00010, 0.00010, 0.00000, 0.00360, 0.00030, 0.00030, 0.00030, 
	0.00400, 0.00040, 0.00050, 0.00100, 0.00240, 0.00010, 0.00010, 0.00100, 
	0.00030, 0.00090, 0.00220, 0.00030, 0.00000, 0.00220, 0.00110, 0.00040, 
	0.00130, 0.00010, 0.00020, 0.00000, 0.00040, 0.00010, 0.00460, 0.00030, 
	0.00030, 0.00030, 0.00550, 0.00010, 0.00010, 0.00010, 0.00350, 0.00000, 
	0.00020, 0.00030, 0.00030, 0.00050, 0.00560, 0.00030, 0.00010, 0.00060, 
	0.00040, 0.00090, 0.00100, 0.00010, 0.00020, 0.00000, 0.00040, 0.00000, 
	0.00550, 0.00110, 0.00650, 0.00310, 0.00400, 0.00150, 0.00280, 0.00030, 
	0.00020, 0.00030, 0.00150, 0.00470, 0.00280, 0.01720, 0.00460, 0.00170, 
	0.00030, 0.00370, 0.00590, 0.00660, 0.00040, 0.00210, 0.00020, 0.00060, 
	0.00030, 0.00100, 0.00110, 0.00000, 0.00000, 0.00000, 0.00080, 0.00000, 
	0.00000, 0.00000, 0.00040, 0.00000, 0.00000, 0.00000, 0.00010, 0.00010, 
	0.00120, 0.00010, 0.00000, 0.00000, 0.00010, 0.00000, 0.00060, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00240, 0.00030, 0.00030, 0.00020, 
	0.00320, 0.00020, 0.00010, 0.00040, 0.00240, 0.00010, 0.00020, 0.00060, 
	0.00040, 0.00030, 0.00140, 0.00030, 0.00000, 0.00050, 0.00140, 0.00060, 
	0.00080, 0.00010, 0.00020, 0.00000, 0.00050, 0.00010, 0.00700, 0.00060, 
	0.00070, 0.00170, 0.00810, 0.00060, 0.00040, 0.00030, 0.00860, 0.00010, 
	0.00050, 0.00420, 0.00100, 0.00030, 0.00610, 0.00080, 0.00000, 0.00070, 
	0.00200, 0.00180, 0.00230, 0.00030, 0.00030, 0.00000, 0.00140, 0.00010, 
	0.00870, 0.00130, 0.00040, 0.00020, 0.00690, 0.00020, 0.00020, 0.00010, 
	0.00360, 0.00010, 0.00010, 0.00030, 0.00100, 0.00020, 0.00430, 0.00190, 
	0.00000, 0.00020, 0.00120, 0.00030, 0.00240, 0.00010, 0.00010, 0.00000, 
	0.00140, 0.00010, 0.00510, 0.00080, 0.00290, 0.00580, 0.00990, 0.00120, 
	0.00660, 0.00060, 0.00440, 0.00030, 0.00180, 0.00200, 0.00070, 0.00150, 
	0.00320, 0.00070, 0.00010, 0.00040, 0.00420, 0.00670, 0.00100, 0.00050, 
	0.00040, 0.00010, 0.00090, 0.00040, 0.00130, 0.00220, 0.00250, 0.00270, 
	0.00080, 0.00200, 0.00300, 0.00050, 0.00120, 0.00040, 0.00180, 0.00450, 
	0.00590, 0.01140, 0.00370, 0.00350, 0.00010, 0.01130, 0.00470, 0.00410, 
	0.00520, 0.00190, 0.00220, 0.00060, 0.00080, 0.00040, 0.00430, 0.00020, 
	0.00040, 0.00020, 0.00360, 0.00020, 0.00020, 0.00130, 0.00230, 0.00000, 
	0.00010, 0.00230, 0.00030, 0.00020, 0.00430, 0.00130, 0.00000, 0.00420, 
	0.00120, 0.00080, 0.00100, 0.00010, 0.00010, 0.00000, 0.00030, 0.00000, 
	0.00010, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00010, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00120, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00960, 0.00100, 0.00190, 0.00250, 0.01320, 0.00070, 
	0.00120, 0.00040, 0.00710, 0.00020, 0.00220, 0.00180, 0.00170, 0.00220, 
	0.00700, 0.00090, 0.00010, 0.00110, 0.00390, 0.00480, 0.00240, 0.00100, 
	0.00040, 0.00010, 0.00180, 0.00020, 0.00410, 0.00080, 0.00280, 0.00080, 
	0.00750, 0.00070, 0.00050, 0.00450, 0.00570, 0.00010, 0.00110, 0.00100, 
	0.00160, 0.00060, 0.00370, 0.00290, 0.00020, 0.00050, 0.00420, 0.01050, 
	0.00240, 0.00030, 0.00080, 0.00010, 0.00090, 0.00020, 0.00720, 0.00070, 
	0.00130, 0.00050, 0.01060, 0.00050, 0.00040, 0.00480, 0.00820, 0.00010, 
	0.00020, 0.00090, 0.00080, 0.00060, 0.00740, 0.00070, 0.00000, 0.00520, 
	0.00330, 0.00180, 0.00440, 0.00070, 0.00110, 0.00010, 0.00200, 0.00020, 
	0.00110, 0.00270, 0.00130, 0.00120, 0.00160, 0.00030, 0.00070, 0.00020, 
	0.00130, 0.00020, 0.00060, 0.00190, 0.00240, 0.00370, 0.00030, 0.00170, 
	0.00000, 0.00480, 0.00520, 0.00370, 0.00010, 0.00020, 0.00010, 0.00030, 
	0.00030, 0.00030, 0.00180, 0.00010, 0.00010, 0.00010, 0.00500, 0.00000, 
	0.00010, 0.00000, 0.00400, 0.00000, 0.00010, 0.00010, 0.00010, 0.00010, 
	0.00100, 0.00010, 0.00000, 0.00010, 0.00020, 0.00010, 0.00010, 0.00000, 
	0.00000, 0.00000, 0.00010, 0.00000, 0.00220, 0.00010, 0.00010, 0.00010, 
	0.00330, 0.00010, 0.00010, 0.00050, 0.00160, 0.00000, 0.00010, 0.00010, 
	0.00010, 0.00050, 0.00240, 0.00020, 0.00000, 0.00020, 0.00110, 0.00020, 
	0.00010, 0.00000, 0.00010, 0.00000, 0.00010, 0.00000, 0.00030, 0.00010, 
	0.00030, 0.00010, 0.00030, 0.00010, 0.00010, 0.00010, 0.00050, 0.00000, 
	0.00000, 0.00010, 0.00010, 0.00020, 0.00020, 0.00060, 0.00000, 0.00010, 
	0.00020, 0.00050, 0.00010, 0.00010, 0.00010, 0.00040, 0.00020, 0.00000, 
	0.00150, 0.00070, 0.00080, 0.00050, 0.00070, 0.00040, 0.00030, 0.00030, 
	0.00040, 0.00010, 0.00020, 0.00070, 0.00070, 0.00050, 0.00220, 0.00070, 
	0.00000, 0.00040, 0.00170, 0.00070, 0.00040, 0.00010, 0.00040, 0.00000, 
	0.00010, 0.00010, 0.00100, 0.00010, 0.00010, 0.00010, 0.00090, 0.00000, 
	0.00010, 0.00020, 0.00090, 0.00000, 0.00010, 0.00020, 0.00010, 0.00010, 
	0.00060, 0.00010, 0.00000, 0.00000, 0.00010, 0.00010, 0.00020, 0.00000, 
	0.00010, 0.00000, 0.00020, 0.00030
};

double baseline_trigram[ /*17576*/ ] = 
{
	0.00003, 0.00002, 0.00003, 0.00005, 0.00001, 0.00002, 0.00002, 0.00001, 
	0.00002, 0.00001, 0.00002, 0.00007, 0.00003, 0.00009, 0.00000, 0.00003, 
	0.00000, 0.00013, 0.00004, 0.00005, 0.00002, 0.00001, 0.00001, 0.00000, 
	0.00001, 0.00001, 0.00042, 0.00009, 0.00007, 0.00003, 0.00038, 0.00001, 
	0.00001, 0.00002, 0.00030, 0.00000, 0.00001, 0.00037, 0.00002, 0.00002, 
	0.00034, 0.00001, 0.00000, 0.00017, 0.00016, 0.00002, 0.00014, 0.00000, 
	0.00001, 0.00000, 0.00017, 0.00001, 0.00047, 0.00001, 0.00023, 0.00002, 
	0.00068, 0.00001, 0.00001, 0.00068, 0.00037, 0.00002, 0.00087, 0.00012, 
	0.00003, 0.00002, 0.00036, 0.00002, 0.00002, 0.00011, 0.00004, 0.00064, 
	0.00009, 0.00000, 0.00001, 0.00000, 0.00007, 0.00001, 0.00053, 0.00007, 
	0.00007, 0.00022, 0.00110, 0.00006, 0.00009, 0.00005, 0.00079, 0.00002, 
	0.00002, 0.00006, 0.00014, 0.00005, 0.00050, 0.00005, 0.00000, 0.00015, 
	0.00039, 0.00007, 0.00016, 0.00028, 0.00005, 0.00000, 0.00013, 0.00003, 
	0.00001, 0.00001, 0.00003, 0.00004, 0.00001, 0.00001, 0.00002, 0.00001, 
	0.00001, 0.00000, 0.00001, 0.00010, 0.00004, 0.00006, 0.00001, 0.00001, 
	0.00000, 0.00008, 0.00008, 0.00002, 0.00002, 0.00002, 0.00000, 0.00004, 
	0.00000, 0.00000, 0.00017, 0.00001, 0.00002, 0.00001, 0.00025, 0.00036, 
	0.00001, 0.00000, 0.00020, 0.00000, 0.00000, 0.00004, 0.00001, 0.00001, 
	0.00013, 0.00001, 0.00000, 0.00014, 0.00002, 0.00022, 0.00004, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00050, 0.00001, 0.00001, 0.00002, 
	0.00137, 0.00001, 0.00005, 0.00004, 0.00029, 0.00000, 0.00000, 0.00006, 
	0.00002, 0.00011, 0.00025, 0.00001, 0.00000, 0.00020, 0.00008, 0.00001, 
	0.00014, 0.00000, 0.00001, 0.00000, 0.00001, 0.00001, 0.00021, 0.00002, 
	0.00001, 0.00002, 0.00007, 0.00001, 0.00001, 0.00001, 0.00009, 0.00001, 
	0.00001, 0.00004, 0.00004, 0.00004, 0.00020, 0.00001, 0.00000, 0.00006, 
	0.00003, 0.00002, 0.00004, 0.00001, 0.00001, 0.00000, 0.00001, 0.00000, 
	0.00005, 0.00005, 0.00006, 0.00016, 0.00002, 0.00003, 0.00008, 0.00003, 
	0.00003, 0.00004, 0.00007, 0.00086, 0.00010, 0.00093, 0.00002, 0.00005, 
	0.00001, 0.00064, 0.00025, 0.00015, 0.00001, 0.00002, 0.00003, 0.00004, 
	0.00002, 0.00002, 0.00016, 0.00000, 0.00000, 0.00001, 0.00008, 0.00000, 
	0.00000, 0.00000, 0.00005, 0.00000, 0.00001, 0.00001, 0.00001, 0.00001, 
	0.00009, 0.00001, 0.00000, 0.00001, 0.00001, 0.00001, 0.00004, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00029, 0.00002, 0.00002, 0.00002, 
	0.00055, 0.00002, 0.00001, 0.00005, 0.00025, 0.00000, 0.00004, 0.00003, 
	0.00002, 0.00002, 0.00012, 0.00002, 0.00000, 0.00003, 0.00009, 0.00012, 
	0.00016, 0.00001, 0.00001, 0.00000, 0.00002, 0.00001, 0.00084, 0.00025, 
	0.00030, 0.00028, 0.00113, 0.00018, 0.00015, 0.00012, 0.00107, 0.00004, 
	0.00030, 0.00168, 0.00035, 0.00010, 0.00045, 0.00027, 0.00002, 0.00010, 
	0.00065, 0.00085, 0.00019, 0.00010, 0.00012, 0.00001, 0.00014, 0.00004, 
	0.00105, 0.00028, 0.00006, 0.00004, 0.00144, 0.00003, 0.00004, 0.00003, 
	0.00073, 0.00001, 0.00003, 0.00004, 0.00017, 0.00004, 0.00040, 0.00040, 
	0.00000, 0.00005, 0.00030, 0.00007, 0.00013, 0.00002, 0.00003, 0.00001, 
	0.00004, 0.00002, 0.00114, 0.00023, 0.00112, 0.00261, 0.00080, 0.00012, 
	0.00113, 0.00015, 0.00095, 0.00010, 0.00076, 0.00012, 0.00016, 0.00057, 
	0.00048, 0.00016, 0.00004, 0.00008, 0.00087, 0.00131, 0.00017, 0.00006, 
	0.00009, 0.00003, 0.00026, 0.00014, 0.00001, 0.00004, 0.00004, 0.00003, 
	0.00001, 0.00003, 0.00001, 0.00002, 0.00001, 0.00001, 0.00002, 0.00003, 
	0.00002, 0.00013, 0.00001, 0.00003, 0.00000, 0.00002, 0.00005, 0.00003, 
	0.00002, 0.00003, 0.00001, 0.00001, 0.00002, 0.00001, 0.00040, 0.00002, 
	0.00004, 0.00002, 0.00046, 0.00002, 0.00001, 0.00023, 0.00028, 0.00000, 
	0.00003, 0.00011, 0.00003, 0.00002, 0.00026, 0.00066, 0.00000, 0.00021, 
	0.00011, 0.00013, 0.00007, 0.00000, 0.00001, 0.00000, 0.00003, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00013, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00113, 0.00022, 0.00073, 0.00103, 0.00147, 0.00009, 
	0.00028, 0.00006, 0.00112, 0.00003, 0.00128, 0.00024, 0.00047, 0.00033, 
	0.00035, 0.00015, 0.00004, 0.00032, 0.00052, 0.00200, 0.00018, 0.00008, 
	0.00005, 0.00001, 0.00030, 0.00005, 0.00046, 0.00006, 0.00021, 0.00011, 
	0.00054, 0.00004, 0.00005, 0.00094, 0.00069, 0.00001, 0.00019, 0.00006, 
	0.00011, 0.00005, 0.00024, 0.00022, 0.00001, 0.00006, 0.00090, 0.00134, 
	0.00014, 0.00004, 0.00005, 0.00001, 0.00026, 0.00002, 0.00066, 0.00006, 
	0.00031, 0.00004, 0.00171, 0.00006, 0.00004, 0.00047, 0.00194, 0.00001, 
	0.00005, 0.00013, 0.00008, 0.00005, 0.00064, 0.00006, 0.00000, 0.00034, 
	0.00032, 0.00043, 0.00052, 0.00007, 0.00005, 0.00000, 0.00005, 0.00004, 
	0.00001, 0.00004, 0.00010, 0.00019, 0.00004, 0.00005, 0.00007, 0.00001, 
	0.00001, 0.00001, 0.00003, 0.00013, 0.00005, 0.00011, 0.00001, 0.00003, 
	0.00000, 0.00016, 0.00028, 0.00072, 0.00000, 0.00001, 0.00000, 0.00004, 
	0.00000, 0.00001, 0.00029, 0.00001, 0.00001, 0.00001, 0.00087, 0.00001, 
	0.00001, 0.00000, 0.00049, 0.00000, 0.00002, 0.00001, 0.00001, 0.00001, 
	0.00016, 0.00001, 0.00000, 0.00002, 0.00002, 0.00005, 0.00002, 0.00002, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00029, 0.00001, 0.00001, 0.00001, 
	0.00016, 0.00002, 0.00001, 0.00002, 0.00005, 0.00000, 0.00003, 0.00002, 
	0.00001, 0.00003, 0.00010, 0.00001, 0.00000, 0.00002, 0.00004, 0.00001, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00003, 0.00000, 0.00003, 0.00001, 
	0.00002, 0.00001, 0.00003, 0.00001, 0.00001, 0.00001, 0.00012, 0.00000, 
	0.00000, 0.00001, 0.00002, 0.00001, 0.00002, 0.00002, 0.00000, 0.00001, 
	0.00002, 0.00002, 0.00001, 0.00000, 0.00001, 0.00002, 0.00004, 0.00000, 
	0.00027, 0.00007, 0.00006, 0.00006, 0.00015, 0.00005, 0.00004, 0.00004, 
	0.00006, 0.00001, 0.00001, 0.00007, 0.00009, 0.00005, 0.00009, 0.00007, 
	0.00000, 0.00004, 0.00030, 0.00010, 0.00004, 0.00002, 0.00003, 0.00000, 
	0.00001, 0.00001, 0.00026, 0.00002, 0.00001, 0.00004, 0.00016, 0.00001, 
	0.00001, 0.00002, 0.00039, 0.00000, 0.00001, 0.00001, 0.00002, 0.00001, 
	0.00008, 0.00001, 0.00000, 0.00001, 0.00001, 0.00001, 0.00004, 0.00001, 
	0.00000, 0.00000, 0.00008, 0.00007, 0.00003, 0.00028, 0.00026, 0.00013, 
	0.00002, 0.00002, 0.00011, 0.00007, 0.00013, 0.00005, 0.00009, 0.00059, 
	0.00006, 0.00091, 0.00007, 0.00003, 0.00000, 0.00050, 0.00031, 0.00020, 
	0.00007, 0.00002, 0.00001, 0.00001, 0.00014, 0.00009, 0.00004, 0.00001, 
	0.00002, 0.00001, 0.00006, 0.00001, 0.00000, 0.00000, 0.00005, 0.00000, 
	0.00000, 0.00006, 0.00001, 0.00000, 0.00004, 0.00001, 0.00001, 0.00001, 
	0.00003, 0.00001, 0.00001, 0.00001, 0.00003, 0.00000, 0.00007, 0.00000, 
	0.00006, 0.00001, 0.00001, 0.00001, 0.00002, 0.00001, 0.00001, 0.00002, 
	0.00001, 0.00000, 0.00000, 0.00002, 0.00001, 0.00002, 0.00007, 0.00001, 
	0.00000, 0.00002, 0.00001, 0.00001, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00001, 0.00001, 0.00001, 0.00012, 0.00000, 
	0.00000, 0.00000, 0.00007, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00001, 0.00003, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00045, 0.00006, 0.00090, 0.00010, 
	0.00012, 0.00003, 0.00004, 0.00004, 0.00007, 0.00001, 0.00002, 0.00041, 
	0.00004, 0.00023, 0.00001, 0.00003, 0.00000, 0.00091, 0.00055, 0.00029, 
	0.00002, 0.00002, 0.00002, 0.00003, 0.00005, 0.00003, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00001, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00002, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00005, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00007, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00015, 0.00008, 0.00007, 0.00007, 
	0.00015, 0.00001, 0.00027, 0.00001, 0.00001, 0.00003, 0.00013, 0.00057, 
	0.00004, 0.00028, 0.00014, 0.00001, 0.00000, 0.00013, 0.00012, 0.00027, 
	0.00001, 0.00001, 0.00001, 0.00000, 0.00001, 0.00023, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00032, 0.00000, 0.00000, 0.00000, 0.00050, 0.00000, 
	0.00000, 0.00000, 0.00038, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00157, 0.00000, 0.00000, 0.00045, 0.00000, 0.00000, 0.00022, 0.00000, 
	0.00000, 0.00000, 0.00004, 0.00000, 0.00011, 0.00000, 0.00001, 0.00000, 
	0.00003, 0.00000, 0.00000, 0.00000, 0.00008, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00001, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00002, 0.00001, 
	0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00019, 0.00007, 0.00003, 0.00013, 0.00003, 0.00002, 0.00004, 0.00001, 
	0.00003, 0.00000, 0.00003, 0.00020, 0.00005, 0.00028, 0.00087, 0.00002, 
	0.00000, 0.00019, 0.00011, 0.00018, 0.00025, 0.00002, 0.00005, 0.00029, 
	0.00014, 0.00001, 0.00004, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00001, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00004, 0.00001, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00060, 0.00000, 
	0.00000, 0.00000, 0.00029, 0.00000, 0.00000, 0.00000, 0.00042, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00033, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00008, 0.00000, 0.00000, 0.00000, 0.00002, 0.00001, 
	0.00003, 0.00001, 0.00004, 0.00001, 0.00010, 0.00001, 0.00001, 0.00004, 
	0.00019, 0.00000, 0.00001, 0.00001, 0.00001, 0.00001, 0.00008, 0.00003, 
	0.00000, 0.00001, 0.00001, 0.00008, 0.00002, 0.00000, 0.00001, 0.00000, 
	0.00001, 0.00000, 0.00002, 0.00000, 0.00001, 0.00000, 0.00004, 0.00000, 
	0.00000, 0.00001, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00003, 0.00000, 0.00000, 0.00003, 0.00001, 0.00000, 0.00001, 0.00001, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00003, 0.00011, 0.00011, 
	0.00004, 0.00002, 0.00004, 0.00001, 0.00016, 0.00001, 0.00003, 0.00017, 
	0.00004, 0.00014, 0.00001, 0.00000, 0.00000, 0.00025, 0.00049, 0.00012, 
	0.00000, 0.00000, 0.00000, 0.00005, 0.00019, 0.00011, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00002, 0.00003, 0.00002, 
	0.00002, 0.00001, 0.00002, 0.00001, 0.00001, 0.00001, 0.00001, 0.00002, 
	0.00002, 0.00002, 0.00002, 0.00002, 0.00000, 0.00002, 0.00005, 0.00006, 
	0.00000, 0.00001, 0.00001, 0.00000, 0.00000, 0.00001, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00012, 0.00011, 0.00029, 0.00003, 0.00013, 0.00006, 0.00002, 
	0.00008, 0.00002, 0.00006, 0.00067, 0.00048, 0.00072, 0.00007, 0.00029, 
	0.00000, 0.00126, 0.00076, 0.00052, 0.00004, 0.00004, 0.00002, 0.00000, 
	0.00001, 0.00001, 0.00004, 0.00001, 0.00001, 0.00001, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 
	0.00003, 0.00000, 0.00000, 0.00001, 0.00001, 0.00001, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00008, 0.00001, 0.00002, 0.00001, 
	0.00022, 0.00001, 0.00000, 0.00004, 0.00008, 0.00000, 0.00000, 0.00002, 
	0.00001, 0.00000, 0.00015, 0.00001, 0.00000, 0.00002, 0.00001, 0.00001, 
	0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00001, 
	0.00001, 0.00001, 0.00004, 0.00001, 0.00000, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00003, 0.00003, 0.00000, 0.00000, 0.00001, 
	0.00001, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00011, 0.00013, 0.00010, 0.00013, 0.00004, 0.00006, 0.00005, 0.00004, 
	0.00006, 0.00001, 0.00003, 0.00035, 0.00011, 0.00069, 0.00005, 0.00015, 
	0.00001, 0.00033, 0.00066, 0.00012, 0.00003, 0.00003, 0.00004, 0.00002, 
	0.00001, 0.00001, 0.00003, 0.00001, 0.00001, 0.00001, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00003, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00115, 0.00007, 
	0.00007, 0.00005, 0.00129, 0.00005, 0.00004, 0.00004, 0.00110, 0.00001, 
	0.00005, 0.00010, 0.00012, 0.00028, 0.00058, 0.00006, 0.00000, 0.00022, 
	0.00013, 0.00020, 0.00020, 0.00002, 0.00008, 0.00000, 0.00003, 0.00002, 
	0.00077, 0.00002, 0.00004, 0.00007, 0.00023, 0.00005, 0.00005, 0.00000, 
	0.00001, 0.00001, 0.00002, 0.00010, 0.00003, 0.00043, 0.00036, 0.00008, 
	0.00000, 0.00008, 0.00008, 0.00046, 0.00002, 0.00003, 0.00001, 0.00000, 
	0.00000, 0.00001, 0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00013, 0.00008, 0.00006, 0.00004, 
	0.00056, 0.00004, 0.00004, 0.00005, 0.00016, 0.00001, 0.00001, 0.00012, 
	0.00008, 0.00003, 0.00007, 0.00009, 0.00000, 0.00004, 0.00037, 0.00010, 
	0.00004, 0.00001, 0.00004, 0.00000, 0.00009, 0.00001, 0.00040, 0.00000, 
	0.00000, 0.00000, 0.00048, 0.00000, 0.00000, 0.00000, 0.00051, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00029, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00001, 0.00053, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00008, 0.00000, 0.00001, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00001, 
	0.00000, 0.00000, 0.00005, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00002, 0.00001, 0.00001, 0.00000, 0.00006, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 
	0.00004, 0.00000, 0.00000, 0.00000, 0.00001, 0.00001, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00016, 0.00006, 0.00014, 0.00031, 
	0.00004, 0.00008, 0.00003, 0.00002, 0.00009, 0.00001, 0.00001, 0.00059, 
	0.00271, 0.00139, 0.00030, 0.00017, 0.00001, 0.00070, 0.00030, 0.00015, 
	0.00058, 0.00014, 0.00005, 0.00001, 0.00001, 0.00002, 0.00006, 0.00000, 
	0.00001, 0.00000, 0.00002, 0.00000, 0.00000, 0.00001, 0.00001, 0.00000, 
	0.00000, 0.00002, 0.00001, 0.00000, 0.00003, 0.00000, 0.00000, 0.00004, 
	0.00001, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00039, 0.00000, 0.00000, 0.00000, 0.00068, 0.00000, 
	0.00000, 0.00000, 0.00029, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 
	0.00030, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00016, 0.00000, 
	0.00000, 0.00000, 0.00004, 0.00000, 0.00003, 0.00001, 0.00003, 0.00001, 
	0.00005, 0.00001, 0.00001, 0.00004, 0.00003, 0.00000, 0.00001, 0.00001, 
	0.00002, 0.00001, 0.00004, 0.00003, 0.00000, 0.00001, 0.00005, 0.00006, 
	0.00004, 0.00000, 0.00001, 0.00000, 0.00001, 0.00000, 0.00008, 0.00002, 
	0.00002, 0.00002, 0.00008, 0.00002, 0.00001, 0.00002, 0.00068, 0.00000, 
	0.00000, 0.00002, 0.00003, 0.00001, 0.00074, 0.00002, 0.00000, 0.00021, 
	0.00018, 0.00002, 0.00019, 0.00002, 0.00002, 0.00000, 0.00001, 0.00000, 
	0.00003, 0.00007, 0.00003, 0.00001, 0.00006, 0.00001, 0.00000, 0.00000, 
	0.00005, 0.00000, 0.00001, 0.00023, 0.00006, 0.00004, 0.00002, 0.00007, 
	0.00000, 0.00035, 0.00017, 0.00010, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00001, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00003, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00009, 0.00010, 0.00001, 0.00000, 0.00001, 0.00001, 0.00000, 
	0.00000, 0.00001, 0.00001, 0.00001, 0.00001, 0.00001, 0.00001, 0.00002, 
	0.00000, 0.00001, 0.00001, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00002, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00004, 0.00009, 0.00011, 0.00025, 
	0.00003, 0.00006, 0.00008, 0.00005, 0.00036, 0.00002, 0.00005, 0.00020, 
	0.00018, 0.00042, 0.00004, 0.00009, 0.00001, 0.00033, 0.00024, 0.00050, 
	0.00004, 0.00012, 0.00005, 0.00001, 0.00049, 0.00003, 0.00012, 0.00001, 
	0.00001, 0.00001, 0.00006, 0.00000, 0.00000, 0.00000, 0.00004, 0.00000, 
	0.00000, 0.00006, 0.00000, 0.00000, 0.00008, 0.00000, 0.00000, 0.00004, 
	0.00001, 0.00000, 0.00006, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00013, 0.00001, 0.00001, 0.00001, 0.00003, 0.00000, 0.00000, 0.00006, 
	0.00002, 0.00000, 0.00000, 0.00005, 0.00001, 0.00000, 0.00019, 0.00000, 
	0.00000, 0.00004, 0.00001, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00005, 0.00001, 0.00001, 0.00001, 0.00012, 0.00001, 
	0.00000, 0.00001, 0.00023, 0.00000, 0.00000, 0.00005, 0.00001, 0.00000, 
	0.00004, 0.00000, 0.00000, 0.00003, 0.00002, 0.00001, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00007, 0.00000, 0.00053, 0.00017, 0.00031, 0.00014, 
	0.00014, 0.00014, 0.00010, 0.00005, 0.00010, 0.00003, 0.00005, 0.00070, 
	0.00040, 0.00073, 0.00050, 0.00024, 0.00001, 0.00123, 0.00128, 0.00019, 
	0.00009, 0.00029, 0.00005, 0.00013, 0.00002, 0.00004, 0.00006, 0.00001, 
	0.00001, 0.00001, 0.00002, 0.00000, 0.00000, 0.00000, 0.00007, 0.00000, 
	0.00000, 0.00003, 0.00000, 0.00000, 0.00008, 0.00000, 0.00000, 0.00005, 
	0.00001, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00008, 0.00000, 0.00000, 0.00000, 0.00029, 0.00000, 0.00000, 0.00000, 
	0.00003, 0.00000, 0.00000, 0.00001, 0.00001, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00004, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00009, 0.00000, 0.00000, 0.00001, 0.00007, 0.00000, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00010, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00159, 0.00004, 0.00037, 0.00007, 
	0.00034, 0.00005, 0.00045, 0.00001, 0.00001, 0.00001, 0.00004, 0.00005, 
	0.00009, 0.00071, 0.00057, 0.00005, 0.00001, 0.00080, 0.00054, 0.00035, 
	0.00004, 0.00015, 0.00002, 0.00001, 0.00005, 0.00005, 0.00003, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00003, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00001, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00007, 0.00000, 0.00001, 0.00000, 0.00016, 0.00000, 
	0.00000, 0.00000, 0.00013, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00005, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00019, 0.00000, 0.00001, 0.00000, 
	0.00009, 0.00000, 0.00000, 0.00000, 0.00011, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00011, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00003, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 0.00004, 0.00000, 
	0.00000, 0.00000, 0.00014, 0.00000, 0.00000, 0.00000, 0.00004, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 
	0.00005, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00004, 0.00007, 0.00020, 0.00006, 0.00005, 0.00008, 0.00014, 0.00003, 
	0.00004, 0.00002, 0.00005, 0.00017, 0.00047, 0.00041, 0.00015, 0.00007, 
	0.00000, 0.00030, 0.00025, 0.00013, 0.00011, 0.00005, 0.00038, 0.00002, 
	0.00001, 0.00001, 0.00007, 0.00000, 0.00001, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00002, 0.00003, 0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 
	0.00007, 0.00000, 0.00000, 0.00065, 0.00001, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00024, 0.00001, 
	0.00001, 0.00001, 0.00044, 0.00000, 0.00001, 0.00001, 0.00024, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00034, 0.00001, 0.00000, 0.00000, 
	0.00001, 0.00001, 0.00010, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 
	0.00008, 0.00003, 0.00009, 0.00002, 0.00013, 0.00003, 0.00002, 0.00009, 
	0.00006, 0.00000, 0.00002, 0.00004, 0.00006, 0.00002, 0.00012, 0.00009, 
	0.00001, 0.00001, 0.00003, 0.00017, 0.00005, 0.00001, 0.00003, 0.00000, 
	0.00002, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 0.00007, 0.00000, 
	0.00000, 0.00008, 0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00007, 0.00000, 0.00000, 0.00009, 0.00001, 0.00000, 0.00005, 0.00002, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00004, 0.00007, 0.00031, 0.00003, 
	0.00002, 0.00001, 0.00002, 0.00001, 0.00002, 0.00001, 0.00004, 0.00014, 
	0.00006, 0.00012, 0.00002, 0.00005, 0.00000, 0.00009, 0.00013, 0.00005, 
	0.00000, 0.00001, 0.00001, 0.00000, 0.00000, 0.00001, 0.00007, 0.00000, 
	0.00000, 0.00004, 0.00015, 0.00000, 0.00000, 0.00000, 0.00012, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00012, 0.00000, 0.00000, 0.00000, 0.00008, 0.00000, 0.00000, 0.00001, 
	0.00009, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00009, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00004, 0.00004, 0.00003, 0.00001, 
	0.00001, 0.00001, 0.00002, 0.00001, 0.00001, 0.00001, 0.00001, 0.00002, 
	0.00003, 0.00007, 0.00005, 0.00002, 0.00000, 0.00001, 0.00006, 0.00003, 
	0.00001, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00004, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00005, 0.00026, 0.00050, 0.00001, 0.00007, 0.00011, 0.00003, 
	0.00003, 0.00000, 0.00020, 0.00110, 0.00054, 0.00045, 0.00001, 0.00018, 
	0.00001, 0.00101, 0.00057, 0.00073, 0.00031, 0.00008, 0.00004, 0.00000, 
	0.00000, 0.00002, 0.00038, 0.00006, 0.00009, 0.00017, 0.00040, 0.00003, 
	0.00003, 0.00006, 0.00023, 0.00001, 0.00002, 0.00029, 0.00010, 0.00004, 
	0.00043, 0.00006, 0.00000, 0.00021, 0.00035, 0.00009, 0.00021, 0.00001, 
	0.00003, 0.00000, 0.00004, 0.00001, 0.00042, 0.00001, 0.00005, 0.00002, 
	0.00020, 0.00001, 0.00001, 0.00111, 0.00027, 0.00000, 0.00019, 0.00019, 
	0.00002, 0.00005, 0.00178, 0.00001, 0.00000, 0.00030, 0.00003, 0.00146, 
	0.00026, 0.00000, 0.00001, 0.00000, 0.00002, 0.00002, 0.00036, 0.00011, 
	0.00010, 0.00017, 0.00060, 0.00005, 0.00011, 0.00005, 0.00154, 0.00001, 
	0.00002, 0.00007, 0.00009, 0.00005, 0.00031, 0.00007, 0.00000, 0.00012, 
	0.00022, 0.00009, 0.00033, 0.00003, 0.00006, 0.00001, 0.00006, 0.00002, 
	0.00009, 0.00013, 0.00012, 0.00040, 0.00003, 0.00006, 0.00005, 0.00004, 
	0.00003, 0.00002, 0.00031, 0.00023, 0.00012, 0.00063, 0.00003, 0.00022, 
	0.00001, 0.00029, 0.00022, 0.00041, 0.00002, 0.00006, 0.00006, 0.00006, 
	0.00001, 0.00005, 0.00021, 0.00001, 0.00002, 0.00001, 0.00017, 0.00009, 
	0.00000, 0.00000, 0.00024, 0.00000, 0.00000, 0.00008, 0.00001, 0.00000, 
	0.00031, 0.00000, 0.00000, 0.00015, 0.00002, 0.00003, 0.00011, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00056, 0.00001, 0.00001, 0.00000, 
	0.00028, 0.00001, 0.00005, 0.00002, 0.00030, 0.00000, 0.00000, 0.00005, 
	0.00001, 0.00003, 0.00028, 0.00001, 0.00000, 0.00024, 0.00002, 0.00001, 
	0.00014, 0.00000, 0.00001, 0.00000, 0.00006, 0.00000, 0.00016, 0.00002, 
	0.00000, 0.00003, 0.00012, 0.00000, 0.00000, 0.00000, 0.00008, 0.00000, 
	0.00001, 0.00002, 0.00002, 0.00002, 0.00029, 0.00001, 0.00001, 0.00006, 
	0.00001, 0.00001, 0.00006, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00003, 0.00004, 0.00008, 0.00009, 0.00002, 0.00003, 0.00012, 0.00002, 
	0.00001, 0.00002, 0.00004, 0.00012, 0.00010, 0.00062, 0.00002, 0.00003, 
	0.00000, 0.00012, 0.00024, 0.00021, 0.00000, 0.00001, 0.00001, 0.00001, 
	0.00001, 0.00003, 0.00009, 0.00000, 0.00000, 0.00000, 0.00005, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00012, 0.00003, 0.00000, 0.00000, 0.00001, 0.00000, 0.00004, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00014, 0.00002, 0.00002, 0.00001, 
	0.00011, 0.00001, 0.00001, 0.00003, 0.00013, 0.00000, 0.00003, 0.00008, 
	0.00002, 0.00006, 0.00011, 0.00002, 0.00000, 0.00003, 0.00010, 0.00012, 
	0.00003, 0.00000, 0.00001, 0.00000, 0.00001, 0.00000, 0.00064, 0.00013, 
	0.00015, 0.00022, 0.00107, 0.00014, 0.00009, 0.00008, 0.00089, 0.00002, 
	0.00006, 0.00110, 0.00014, 0.00007, 0.00046, 0.00025, 0.00000, 0.00007, 
	0.00046, 0.00022, 0.00013, 0.00006, 0.00005, 0.00000, 0.00010, 0.00002, 
	0.00099, 0.00014, 0.00003, 0.00003, 0.00088, 0.00001, 0.00001, 0.00001, 
	0.00042, 0.00001, 0.00001, 0.00003, 0.00006, 0.00001, 0.00058, 0.00050, 
	0.00000, 0.00002, 0.00015, 0.00002, 0.00011, 0.00001, 0.00001, 0.00000, 
	0.00016, 0.00000, 0.00045, 0.00016, 0.00070, 0.00090, 0.00087, 0.00012, 
	0.00048, 0.00012, 0.00048, 0.00006, 0.00012, 0.00015, 0.00012, 0.00026, 
	0.00031, 0.00013, 0.00001, 0.00009, 0.00083, 0.00297, 0.00016, 0.00010, 
	0.00010, 0.00002, 0.00007, 0.00011, 0.00003, 0.00006, 0.00007, 0.00005, 
	0.00002, 0.00015, 0.00005, 0.00002, 0.00003, 0.00001, 0.00002, 0.00006, 
	0.00006, 0.00030, 0.00001, 0.00018, 0.00000, 0.00010, 0.00026, 0.00007, 
	0.00006, 0.00003, 0.00003, 0.00001, 0.00001, 0.00001, 0.00045, 0.00001, 
	0.00003, 0.00001, 0.00018, 0.00001, 0.00000, 0.00012, 0.00019, 0.00000, 
	0.00001, 0.00018, 0.00001, 0.00001, 0.00047, 0.00005, 0.00000, 0.00037, 
	0.00008, 0.00012, 0.00011, 0.00000, 0.00001, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00015, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00114, 0.00048, 0.00074, 0.00038, 0.00097, 0.00041, 
	0.00052, 0.00023, 0.00133, 0.00010, 0.00024, 0.00046, 0.00059, 0.00088, 
	0.00072, 0.00044, 0.00001, 0.00050, 0.00256, 0.00113, 0.00021, 0.00077, 
	0.00022, 0.00003, 0.00043, 0.00011, 0.00050, 0.00016, 0.00055, 0.00017, 
	0.00069, 0.00012, 0.00007, 0.00049, 0.00102, 0.00003, 0.00015, 0.00013, 
	0.00017, 0.00009, 0.00051, 0.00047, 0.00003, 0.00007, 0.00229, 0.00242, 
	0.00028, 0.00004, 0.00010, 0.00001, 0.00006, 0.00003, 0.00058, 0.00011, 
	0.00020, 0.00007, 0.00061, 0.00008, 0.00006, 0.00032, 0.00083, 0.00002, 
	0.00004, 0.00008, 0.00015, 0.00008, 0.00039, 0.00014, 0.00000, 0.00053, 
	0.00054, 0.00055, 0.00026, 0.00009, 0.00044, 0.00001, 0.00011, 0.00006, 
	0.00001, 0.00002, 0.00002, 0.00002, 0.00002, 0.00001, 0.00003, 0.00001, 
	0.00001, 0.00000, 0.00002, 0.00002, 0.00006, 0.00009, 0.00001, 0.00008, 
	0.00000, 0.00047, 0.00012, 0.00009, 0.00000, 0.00001, 0.00002, 0.00004, 
	0.00000, 0.00001, 0.00019, 0.00001, 0.00001, 0.00001, 0.00069, 0.00000, 
	0.00001, 0.00000, 0.00058, 0.00000, 0.00001, 0.00001, 0.00001, 0.00002, 
	0.00019, 0.00001, 0.00000, 0.00003, 0.00002, 0.00001, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00026, 0.00004, 0.00003, 0.00002, 
	0.00037, 0.00002, 0.00001, 0.00004, 0.00017, 0.00001, 0.00000, 0.00002, 
	0.00004, 0.00001, 0.00024, 0.00004, 0.00000, 0.00003, 0.00099, 0.00003, 
	0.00001, 0.00001, 0.00002, 0.00000, 0.00003, 0.00001, 0.00015, 0.00003, 
	0.00018, 0.00003, 0.00008, 0.00003, 0.00003, 0.00003, 0.00017, 0.00001, 
	0.00001, 0.00002, 0.00004, 0.00002, 0.00007, 0.00054, 0.00000, 0.00002, 
	0.00006, 0.00040, 0.00004, 0.00003, 0.00002, 0.00004, 0.00010, 0.00000, 
	0.00007, 0.00005, 0.00004, 0.00003, 0.00013, 0.00003, 0.00002, 0.00002, 
	0.00003, 0.00001, 0.00001, 0.00003, 0.00006, 0.00002, 0.00013, 0.00003, 
	0.00000, 0.00003, 0.00013, 0.00004, 0.00001, 0.00001, 0.00004, 0.00000, 
	0.00000, 0.00000, 0.00007, 0.00001, 0.00001, 0.00002, 0.00008, 0.00001, 
	0.00001, 0.00002, 0.00007, 0.00000, 0.00000, 0.00001, 0.00001, 0.00001, 
	0.00006, 0.00001, 0.00000, 0.00001, 0.00001, 0.00001, 0.00003, 0.00001, 
	0.00001, 0.00000, 0.00001, 0.00003, 0.00001, 0.00010, 0.00036, 0.00003, 
	0.00002, 0.00001, 0.00002, 0.00003, 0.00014, 0.00001, 0.00004, 0.00009, 
	0.00018, 0.00035, 0.00000, 0.00002, 0.00002, 0.00025, 0.00038, 0.00010, 
	0.00002, 0.00004, 0.00001, 0.00002, 0.00001, 0.00002, 0.00003, 0.00000, 
	0.00001, 0.00000, 0.00002, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00002, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00001, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00003, 0.00001, 0.00001, 0.00001, 0.00001, 0.00001, 0.00000, 0.00002, 
	0.00001, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00004, 0.00000, 
	0.00000, 0.00001, 0.00001, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00005, 0.00003, 0.00012, 0.00006, 
	0.00017, 0.00002, 0.00001, 0.00001, 0.00006, 0.00000, 0.00001, 0.00010, 
	0.00009, 0.00015, 0.00002, 0.00002, 0.00000, 0.00042, 0.00026, 0.00010, 
	0.00002, 0.00002, 0.00002, 0.00001, 0.00001, 0.00001, 0.00006, 0.00001, 
	0.00002, 0.00001, 0.00022, 0.00001, 0.00000, 0.00001, 0.00044, 0.00000, 
	0.00000, 0.00003, 0.00001, 0.00001, 0.00004, 0.00001, 0.00000, 0.00003, 
	0.00004, 0.00001, 0.00001, 0.00000, 0.00001, 0.00000, 0.00001, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00005, 0.00002, 0.00043, 0.00004, 
	0.00022, 0.00003, 0.00007, 0.00000, 0.00000, 0.00001, 0.00003, 0.00073, 
	0.00002, 0.00061, 0.00001, 0.00001, 0.00000, 0.00030, 0.00017, 0.00034, 
	0.00000, 0.00004, 0.00000, 0.00006, 0.00001, 0.00001, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00020, 0.00000, 0.00000, 0.00000, 0.00013, 0.00000, 
	0.00000, 0.00000, 0.00016, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00023, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00005, 0.00001, 
	0.00000, 0.00000, 0.00011, 0.00000, 0.00005, 0.00000, 0.00001, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00002, 0.00007, 0.00001, 0.00001, 0.00001, 0.00004, 0.00001, 
	0.00001, 0.00000, 0.00001, 0.00014, 0.00002, 0.00016, 0.00033, 0.00002, 
	0.00000, 0.00184, 0.00007, 0.00020, 0.00011, 0.00001, 0.00001, 0.00008, 
	0.00000, 0.00001, 0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00035, 0.00000, 
	0.00000, 0.00000, 0.00112, 0.00000, 0.00000, 0.00000, 0.00026, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00019, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00006, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00002, 0.00001, 0.00002, 0.00000, 0.00002, 0.00000, 0.00000, 0.00003, 
	0.00001, 0.00000, 0.00001, 0.00001, 0.00000, 0.00000, 0.00002, 0.00002, 
	0.00000, 0.00000, 0.00000, 0.00003, 0.00001, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00004, 0.00002, 0.00003, 0.00001, 0.00008, 0.00001, 
	0.00001, 0.00007, 0.00004, 0.00000, 0.00000, 0.00001, 0.00002, 0.00001, 
	0.00003, 0.00003, 0.00000, 0.00002, 0.00011, 0.00001, 0.00002, 0.00001, 
	0.00016, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 0.00010, 0.00001, 
	0.00004, 0.00000, 0.00001, 0.00000, 0.00000, 0.00002, 0.00002, 0.00020, 
	0.00004, 0.00036, 0.00000, 0.00000, 0.00000, 0.00010, 0.00008, 0.00013, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00001, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00007, 0.00006, 0.00014, 0.00002, 0.00003, 0.00008, 0.00003, 
	0.00009, 0.00001, 0.00004, 0.00042, 0.00087, 0.00035, 0.00003, 0.00008, 
	0.00000, 0.00046, 0.00022, 0.00022, 0.00004, 0.00002, 0.00003, 0.00000, 
	0.00014, 0.00032, 0.00006, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00005, 0.00000, 0.00000, 
	0.00006, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00007, 0.00000, 0.00000, 0.00000, 
	0.00003, 0.00000, 0.00000, 0.00005, 0.00001, 0.00000, 0.00000, 0.00003, 
	0.00000, 0.00000, 0.00013, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00005, 0.00000, 
	0.00000, 0.00000, 0.00008, 0.00000, 0.00000, 0.00000, 0.00006, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00006, 0.00000, 0.00000, 0.00001, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00010, 0.00008, 0.00007, 0.00007, 0.00015, 0.00004, 0.00003, 0.00003, 
	0.00005, 0.00001, 0.00002, 0.00022, 0.00017, 0.00082, 0.00015, 0.00005, 
	0.00000, 0.00072, 0.00041, 0.00045, 0.00002, 0.00003, 0.00004, 0.00003, 
	0.00001, 0.00002, 0.00018, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00007, 0.00000, 0.00000, 0.00002, 0.00001, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00006, 0.00000, 0.00000, 0.00000, 
	0.00020, 0.00000, 0.00001, 0.00000, 0.00011, 0.00000, 0.00000, 0.00003, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00003, 0.00002, 0.00000, 
	0.00003, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 0.00011, 0.00001, 
	0.00001, 0.00001, 0.00007, 0.00000, 0.00000, 0.00001, 0.00004, 0.00000, 
	0.00000, 0.00002, 0.00001, 0.00001, 0.00008, 0.00001, 0.00000, 0.00001, 
	0.00002, 0.00056, 0.00003, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00016, 0.00002, 0.00018, 0.00005, 0.00014, 0.00013, 0.00005, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00007, 0.00004, 0.00054, 0.00013, 0.00002, 
	0.00001, 0.00034, 0.00018, 0.00037, 0.00002, 0.00004, 0.00001, 0.00001, 
	0.00001, 0.00002, 0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00021, 0.00000, 
	0.00000, 0.00000, 0.00030, 0.00000, 0.00000, 0.00000, 0.00019, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00036, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00015, 0.00001, 0.00000, 0.00000, 0.00005, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00006, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00001, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00011, 0.00002, 0.00002, 0.00001, 0.00021, 0.00001, 
	0.00001, 0.00001, 0.00008, 0.00000, 0.00000, 0.00001, 0.00002, 0.00001, 
	0.00007, 0.00001, 0.00000, 0.00001, 0.00011, 0.00001, 0.00003, 0.00000, 
	0.00001, 0.00000, 0.00001, 0.00000, 0.00006, 0.00004, 0.00007, 0.00009, 
	0.00004, 0.00004, 0.00006, 0.00002, 0.00003, 0.00001, 0.00002, 0.00034, 
	0.00006, 0.00021, 0.00031, 0.00005, 0.00000, 0.00015, 0.00026, 0.00012, 
	0.00008, 0.00006, 0.00003, 0.00000, 0.00001, 0.00002, 0.00005, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00001, 0.00002, 0.00000, 
	0.00000, 0.00003, 0.00000, 0.00000, 0.00005, 0.00000, 0.00000, 0.00005, 
	0.00002, 0.00001, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00095, 0.00000, 0.00000, 0.00000, 0.00052, 0.00000, 
	0.00000, 0.00000, 0.00015, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00064, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00011, 0.00000, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00006, 0.00002, 0.00004, 0.00001, 
	0.00008, 0.00002, 0.00001, 0.00007, 0.00004, 0.00000, 0.00003, 0.00002, 
	0.00005, 0.00001, 0.00006, 0.00006, 0.00000, 0.00001, 0.00002, 0.00011, 
	0.00004, 0.00001, 0.00001, 0.00000, 0.00002, 0.00000, 0.00005, 0.00000, 
	0.00000, 0.00000, 0.00005, 0.00000, 0.00000, 0.00006, 0.00006, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00009, 0.00000, 0.00000, 0.00005, 
	0.00001, 0.00000, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00015, 0.00000, 0.00001, 0.00001, 0.00017, 0.00000, 0.00001, 0.00000, 
	0.00042, 0.00001, 0.00001, 0.00006, 0.00003, 0.00012, 0.00002, 0.00002, 
	0.00000, 0.00016, 0.00008, 0.00004, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00006, 0.00001, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 
	0.00005, 0.00000, 0.00000, 0.00001, 0.00004, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00006, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00003, 0.00001, 0.00001, 0.00001, 0.00001, 0.00001, 0.00001, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00001, 0.00003, 0.00001, 0.00004, 0.00003, 
	0.00000, 0.00000, 0.00002, 0.00001, 0.00001, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00001, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00004, 0.00021, 0.00017, 0.00012, 
	0.00006, 0.00006, 0.00004, 0.00005, 0.00035, 0.00002, 0.00008, 0.00028, 
	0.00033, 0.00094, 0.00007, 0.00017, 0.00001, 0.00089, 0.00015, 0.00045, 
	0.00013, 0.00008, 0.00007, 0.00001, 0.00007, 0.00003, 0.00006, 0.00000, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00004, 0.00000, 0.00000, 0.00005, 0.00000, 0.00000, 0.00002, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00006, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00003, 
	0.00001, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00008, 0.00001, 
	0.00000, 0.00002, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00005, 0.00001, 0.00001, 0.00001, 0.00004, 0.00002, 
	0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00002, 0.00001, 0.00000, 0.00001, 0.00001, 0.00001, 0.00001, 0.00001, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00078, 0.00022, 0.00029, 0.00018, 
	0.00017, 0.00015, 0.00012, 0.00009, 0.00021, 0.00003, 0.00006, 0.00047, 
	0.00050, 0.00048, 0.00007, 0.00016, 0.00001, 0.00103, 0.00041, 0.00017, 
	0.00005, 0.00007, 0.00014, 0.00003, 0.00004, 0.00002, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00002, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00004, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 
	0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00002, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00001, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00008, 0.00007, 0.00027, 0.00008, 
	0.00012, 0.00005, 0.00013, 0.00002, 0.00002, 0.00002, 0.00009, 0.00028, 
	0.00014, 0.00089, 0.00024, 0.00021, 0.00001, 0.00020, 0.00029, 0.00029, 
	0.00001, 0.00009, 0.00001, 0.00001, 0.00002, 0.00002, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00005, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 
	0.00004, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00008, 0.00000, 0.00000, 0.00000, 0.00007, 0.00000, 
	0.00000, 0.00000, 0.00006, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00005, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00013, 0.00000, 0.00001, 0.00000, 
	0.00009, 0.00000, 0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00005, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 0.00004, 0.00001, 
	0.00001, 0.00001, 0.00011, 0.00000, 0.00001, 0.00001, 0.00008, 0.00000, 
	0.00000, 0.00001, 0.00001, 0.00001, 0.00016, 0.00000, 0.00000, 0.00000, 
	0.00003, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00003, 0.00007, 0.00012, 0.00008, 0.00013, 0.00005, 0.00003, 0.00001, 
	0.00008, 0.00001, 0.00004, 0.00038, 0.00064, 0.00042, 0.00035, 0.00107, 
	0.00000, 0.00033, 0.00063, 0.00088, 0.00046, 0.00002, 0.00028, 0.00000, 
	0.00003, 0.00001, 0.00005, 0.00001, 0.00001, 0.00001, 0.00002, 0.00001, 
	0.00000, 0.00001, 0.00001, 0.00000, 0.00000, 0.00002, 0.00001, 0.00000, 
	0.00004, 0.00000, 0.00000, 0.00004, 0.00001, 0.00001, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00009, 0.00001, 
	0.00000, 0.00001, 0.00012, 0.00000, 0.00000, 0.00000, 0.00017, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00011, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00001, 0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00003, 0.00001, 0.00003, 0.00000, 0.00005, 0.00000, 0.00000, 0.00004, 
	0.00002, 0.00000, 0.00001, 0.00001, 0.00001, 0.00000, 0.00003, 0.00002, 
	0.00000, 0.00000, 0.00001, 0.00006, 0.00002, 0.00000, 0.00001, 0.00000, 
	0.00001, 0.00000, 0.00006, 0.00002, 0.00003, 0.00001, 0.00011, 0.00002, 
	0.00001, 0.00004, 0.00007, 0.00000, 0.00001, 0.00004, 0.00006, 0.00002, 
	0.00006, 0.00001, 0.00000, 0.00005, 0.00013, 0.00002, 0.00003, 0.00001, 
	0.00002, 0.00000, 0.00003, 0.00000, 0.00009, 0.00015, 0.00002, 0.00003, 
	0.00003, 0.00001, 0.00004, 0.00001, 0.00005, 0.00000, 0.00003, 0.00005, 
	0.00012, 0.00017, 0.00003, 0.00002, 0.00000, 0.00008, 0.00006, 0.00006, 
	0.00001, 0.00000, 0.00001, 0.00000, 0.00001, 0.00001, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00006, 0.00000, 0.00000, 0.00000, 0.00006, 0.00000, 0.00000, 0.00000, 
	0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00004, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00001, 0.00001, 0.00003, 
	0.00001, 0.00001, 0.00001, 0.00000, 0.00002, 0.00000, 0.00000, 0.00001, 
	0.00001, 0.00001, 0.00002, 0.00006, 0.00000, 0.00001, 0.00004, 0.00002, 
	0.00002, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00005, 0.00011, 0.00016, 0.00015, 0.00005, 0.00006, 0.00014, 0.00005, 
	0.00006, 0.00006, 0.00004, 0.00077, 0.00025, 0.00109, 0.00011, 0.00010, 
	0.00000, 0.00024, 0.00035, 0.00032, 0.00005, 0.00003, 0.00005, 0.00001, 
	0.00001, 0.00003, 0.00018, 0.00004, 0.00001, 0.00001, 0.00021, 0.00000, 
	0.00000, 0.00000, 0.00011, 0.00000, 0.00000, 0.00015, 0.00001, 0.00001, 
	0.00009, 0.00001, 0.00000, 0.00017, 0.00002, 0.00001, 0.00013, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00122, 0.00007, 0.00010, 0.00005, 
	0.00095, 0.00005, 0.00004, 0.00053, 0.00047, 0.00001, 0.00078, 0.00024, 
	0.00008, 0.00003, 0.00054, 0.00007, 0.00000, 0.00014, 0.00060, 0.00028, 
	0.00010, 0.00002, 0.00004, 0.00001, 0.00005, 0.00002, 0.00046, 0.00003, 
	0.00004, 0.00007, 0.00149, 0.00002, 0.00010, 0.00002, 0.00019, 0.00001, 
	0.00001, 0.00003, 0.00003, 0.00003, 0.00019, 0.00003, 0.00000, 0.00005, 
	0.00023, 0.00004, 0.00005, 0.00001, 0.00003, 0.00000, 0.00002, 0.00002, 
	0.00003, 0.00007, 0.00009, 0.00021, 0.00002, 0.00007, 0.00007, 0.00003, 
	0.00002, 0.00002, 0.00004, 0.00026, 0.00009, 0.00066, 0.00002, 0.00005, 
	0.00000, 0.00046, 0.00092, 0.00027, 0.00005, 0.00005, 0.00035, 0.00002, 
	0.00000, 0.00003, 0.00008, 0.00001, 0.00001, 0.00000, 0.00056, 0.00008, 
	0.00000, 0.00000, 0.00028, 0.00000, 0.00000, 0.00003, 0.00001, 0.00000, 
	0.00009, 0.00000, 0.00000, 0.00003, 0.00003, 0.00020, 0.00006, 0.00000, 
	0.00000, 0.00000, 0.00010, 0.00000, 0.00025, 0.00004, 0.00004, 0.00002, 
	0.00021, 0.00002, 0.00007, 0.00062, 0.00045, 0.00000, 0.00000, 0.00005, 
	0.00004, 0.00073, 0.00014, 0.00002, 0.00000, 0.00010, 0.00007, 0.00003, 
	0.00008, 0.00001, 0.00001, 0.00000, 0.00001, 0.00000, 0.00012, 0.00000, 
	0.00000, 0.00001, 0.00004, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00001, 0.00007, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00001, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00001, 0.00000, 0.00001, 0.00001, 0.00001, 0.00005, 0.00000, 0.00000, 
	0.00000, 0.00001, 0.00001, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00001, 0.00008, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00005, 0.00000, 0.00002, 0.00000, 0.00000, 0.00002, 
	0.00004, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00029, 0.00002, 0.00001, 0.00001, 
	0.00037, 0.00001, 0.00001, 0.00003, 0.00025, 0.00000, 0.00004, 0.00005, 
	0.00002, 0.00001, 0.00014, 0.00001, 0.00000, 0.00003, 0.00005, 0.00002, 
	0.00005, 0.00001, 0.00001, 0.00000, 0.00001, 0.00000, 0.00032, 0.00006, 
	0.00005, 0.00033, 0.00088, 0.00008, 0.00005, 0.00003, 0.00060, 0.00001, 
	0.00006, 0.00091, 0.00036, 0.00003, 0.00021, 0.00004, 0.00000, 0.00002, 
	0.00014, 0.00010, 0.00004, 0.00008, 0.00003, 0.00000, 0.00037, 0.00001, 
	0.00067, 0.00008, 0.00003, 0.00005, 0.00070, 0.00001, 0.00005, 0.00002, 
	0.00023, 0.00000, 0.00001, 0.00002, 0.00014, 0.00002, 0.00026, 0.00036, 
	0.00000, 0.00001, 0.00008, 0.00003, 0.00008, 0.00001, 0.00002, 0.00000, 
	0.00001, 0.00000, 0.00112, 0.00015, 0.00054, 0.00140, 0.00338, 0.00079, 
	0.00464, 0.00018, 0.00069, 0.00007, 0.00086, 0.00009, 0.00017, 0.00028, 
	0.00055, 0.00011, 0.00002, 0.00007, 0.00091, 0.00148, 0.00016, 0.00025, 
	0.00007, 0.00003, 0.00009, 0.00004, 0.00004, 0.00004, 0.00008, 0.00009, 
	0.00003, 0.00004, 0.00004, 0.00002, 0.00003, 0.00001, 0.00002, 0.00009, 
	0.00006, 0.00324, 0.00002, 0.00006, 0.00000, 0.00016, 0.00028, 0.00009, 
	0.00009, 0.00003, 0.00003, 0.00001, 0.00001, 0.00001, 0.00015, 0.00002, 
	0.00004, 0.00002, 0.00017, 0.00002, 0.00002, 0.00010, 0.00008, 0.00000, 
	0.00001, 0.00009, 0.00004, 0.00002, 0.00012, 0.00017, 0.00000, 0.00009, 
	0.00028, 0.00016, 0.00004, 0.00001, 0.00001, 0.00000, 0.00001, 0.00002, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00026, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00048, 0.00004, 0.00012, 0.00010, 0.00128, 0.00003, 
	0.00005, 0.00001, 0.00021, 0.00001, 0.00004, 0.00036, 0.00010, 0.00002, 
	0.00022, 0.00007, 0.00000, 0.00005, 0.00022, 0.00024, 0.00007, 0.00002, 
	0.00002, 0.00000, 0.00005, 0.00000, 0.00029, 0.00006, 0.00033, 0.00007, 
	0.00053, 0.00005, 0.00004, 0.00064, 0.00052, 0.00001, 0.00011, 0.00015, 
	0.00027, 0.00008, 0.00026, 0.00017, 0.00001, 0.00005, 0.00041, 0.00159, 
	0.00010, 0.00003, 0.00004, 0.00000, 0.00003, 0.00001, 0.00113, 0.00007, 
	0.00027, 0.00003, 0.00141, 0.00004, 0.00003, 0.00029, 0.00054, 0.00001, 
	0.00003, 0.00006, 0.00009, 0.00014, 0.00035, 0.00006, 0.00000, 0.00016, 
	0.00040, 0.00031, 0.00028, 0.00004, 0.00004, 0.00000, 0.00085, 0.00007, 
	0.00000, 0.00001, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00001, 0.00019, 0.00002, 0.00000, 0.00001, 
	0.00000, 0.00001, 0.00009, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00037, 0.00000, 0.00000, 0.00000, 0.00135, 0.00000, 
	0.00000, 0.00000, 0.00033, 0.00000, 0.00000, 0.00001, 0.00001, 0.00001, 
	0.00012, 0.00001, 0.00000, 0.00003, 0.00001, 0.00001, 0.00001, 0.00000, 
	0.00000, 0.00001, 0.00001, 0.00000, 0.00009, 0.00000, 0.00000, 0.00000, 
	0.00006, 0.00000, 0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00005, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00004, 0.00001, 
	0.00001, 0.00001, 0.00010, 0.00001, 0.00001, 0.00001, 0.00005, 0.00000, 
	0.00000, 0.00001, 0.00002, 0.00001, 0.00002, 0.00002, 0.00000, 0.00001, 
	0.00002, 0.00003, 0.00001, 0.00000, 0.00001, 0.00001, 0.00000, 0.00000, 
	0.00014, 0.00000, 0.00000, 0.00001, 0.00004, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00004, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00015, 0.00002, 0.00002, 0.00002, 0.00019, 0.00001, 
	0.00001, 0.00003, 0.00010, 0.00000, 0.00001, 0.00007, 0.00004, 0.00005, 
	0.00006, 0.00001, 0.00000, 0.00001, 0.00002, 0.00001, 0.00003, 0.00001, 
	0.00001, 0.00000, 0.00001, 0.00010, 0.00001, 0.00004, 0.00010, 0.00004, 
	0.00001, 0.00001, 0.00002, 0.00002, 0.00004, 0.00001, 0.00004, 0.00003, 
	0.00011, 0.00012, 0.00001, 0.00014, 0.00000, 0.00010, 0.00007, 0.00003, 
	0.00001, 0.00008, 0.00002, 0.00001, 0.00004, 0.00004, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00001, 0.00017, 0.00002, 
	0.00003, 0.00002, 0.00000, 0.00001, 0.00000, 0.00000, 0.00002, 0.00002, 
	0.00002, 0.00005, 0.00000, 0.00001, 0.00000, 0.00008, 0.00009, 0.00008, 
	0.00004, 0.00001, 0.00007, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00007, 0.00001, 0.00001, 0.00001, 
	0.00002, 0.00001, 0.00002, 0.00000, 0.00000, 0.00001, 0.00001, 0.00001, 
	0.00006, 0.00008, 0.00000, 0.00000, 0.00000, 0.00001, 0.00001, 0.00002, 
	0.00001, 0.00001, 0.00000, 0.00000, 0.00001, 0.00001, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00038, 0.00002, 0.00001, 0.00004, 0.00000, 0.00004, 0.00008, 
	0.00003, 0.00001, 0.00003, 0.00002, 0.00002, 0.00007, 0.00009, 0.00000, 
	0.00000, 0.00008, 0.00007, 0.00001, 0.00016, 0.00001, 0.00000, 0.00000, 
	0.00007, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00001, 0.00001, 
	0.00001, 0.00000, 0.00000, 0.00001, 0.00001, 0.00001, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00001, 0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00001, 
	0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00001, 0.00000, 0.00002, 
	0.00008, 0.00000, 0.00003, 0.00000, 0.00003, 0.00000, 0.00001, 0.00004, 
	0.00004, 0.00011, 0.00001, 0.00000, 0.00000, 0.00004, 0.00016, 0.00001, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00003, 0.00009, 0.00004, 0.00010, 0.00002, 0.00003, 0.00005, 0.00003, 
	0.00010, 0.00001, 0.00006, 0.00016, 0.00013, 0.00032, 0.00003, 0.00007, 
	0.00000, 0.00035, 0.00018, 0.00024, 0.00005, 0.00003, 0.00005, 0.00000, 
	0.00005, 0.00006, 0.00005, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 
	0.00006, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00004, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00004, 0.00002, 0.00000, 0.00000, 0.00002, 
	0.00000, 0.00000, 0.00016, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 0.00005, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00001, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00005, 0.00003, 0.00004, 0.00014, 0.00008, 0.00003, 0.00002, 0.00002, 
	0.00006, 0.00001, 0.00001, 0.00014, 0.00009, 0.00028, 0.00002, 0.00004, 
	0.00000, 0.00076, 0.00019, 0.00093, 0.00004, 0.00002, 0.00002, 0.00002, 
	0.00021, 0.00001, 0.00003, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00005, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00015, 0.00001, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00009, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00001, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00005, 0.00003, 0.00006, 0.00020, 0.00012, 0.00002, 0.00001, 0.00001, 
	0.00001, 0.00001, 0.00003, 0.00010, 0.00008, 0.00095, 0.00003, 0.00005, 
	0.00000, 0.00008, 0.00016, 0.00024, 0.00000, 0.00001, 0.00003, 0.00000, 
	0.00003, 0.00002, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00005, 0.00000, 0.00000, 0.00000, 
	0.00004, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00014, 0.00000, 
	0.00000, 0.00000, 0.00014, 0.00000, 0.00000, 0.00000, 0.00018, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 0.00005, 0.00000, 
	0.00025, 0.00000, 0.00000, 0.00000, 0.00005, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00005, 0.00001, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 0.00006, 0.00000, 
	0.00000, 0.00000, 0.00007, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00013, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00004, 0.00003, 0.00004, 
	0.00003, 0.00005, 0.00002, 0.00003, 0.00002, 0.00001, 0.00006, 0.00012, 
	0.00013, 0.00024, 0.00006, 0.00006, 0.00000, 0.00015, 0.00011, 0.00006, 
	0.00007, 0.00006, 0.00003, 0.00000, 0.00001, 0.00002, 0.00006, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00002, 0.00002, 0.00000, 
	0.00000, 0.00003, 0.00000, 0.00000, 0.00006, 0.00000, 0.00000, 0.00005, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00014, 0.00000, 0.00000, 0.00000, 0.00013, 0.00000, 
	0.00000, 0.00000, 0.00008, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00007, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00004, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00007, 0.00003, 0.00004, 0.00002, 
	0.00007, 0.00002, 0.00001, 0.00010, 0.00006, 0.00000, 0.00001, 0.00002, 
	0.00004, 0.00001, 0.00007, 0.00005, 0.00000, 0.00001, 0.00002, 0.00012, 
	0.00003, 0.00001, 0.00002, 0.00000, 0.00001, 0.00000, 0.00006, 0.00000, 
	0.00000, 0.00000, 0.00006, 0.00000, 0.00000, 0.00004, 0.00008, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00011, 0.00001, 0.00000, 0.00007, 
	0.00001, 0.00000, 0.00006, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00002, 0.00003, 0.00002, 0.00002, 0.00002, 0.00000, 0.00001, 0.00002, 
	0.00001, 0.00001, 0.00002, 0.00007, 0.00005, 0.00007, 0.00001, 0.00010, 
	0.00000, 0.00013, 0.00008, 0.00003, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00001, 0.00001, 0.00003, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 
	0.00004, 0.00000, 0.00000, 0.00001, 0.00003, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00003, 0.00002, 0.00001, 0.00001, 0.00001, 0.00001, 0.00001, 0.00001, 
	0.00001, 0.00000, 0.00000, 0.00002, 0.00002, 0.00001, 0.00011, 0.00002, 
	0.00000, 0.00001, 0.00003, 0.00002, 0.00002, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00005, 0.00041, 0.00049, 0.00033, 
	0.00003, 0.00008, 0.00021, 0.00008, 0.00016, 0.00003, 0.00011, 0.00011, 
	0.00038, 0.00154, 0.00003, 0.00016, 0.00001, 0.00057, 0.00088, 0.00062, 
	0.00017, 0.00015, 0.00017, 0.00006, 0.00039, 0.00011, 0.00013, 0.00001, 
	0.00000, 0.00000, 0.00010, 0.00000, 0.00000, 0.00000, 0.00005, 0.00000, 
	0.00000, 0.00008, 0.00000, 0.00000, 0.00012, 0.00000, 0.00000, 0.00005, 
	0.00001, 0.00000, 0.00008, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00014, 0.00000, 0.00001, 0.00001, 0.00005, 0.00000, 0.00000, 0.00008, 
	0.00005, 0.00000, 0.00000, 0.00005, 0.00000, 0.00000, 0.00022, 0.00000, 
	0.00000, 0.00003, 0.00001, 0.00000, 0.00005, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00011, 0.00004, 0.00005, 0.00001, 0.00034, 0.00003, 
	0.00002, 0.00002, 0.00021, 0.00001, 0.00001, 0.00003, 0.00005, 0.00002, 
	0.00012, 0.00003, 0.00000, 0.00006, 0.00010, 0.00005, 0.00003, 0.00001, 
	0.00006, 0.00000, 0.00001, 0.00000, 0.00066, 0.00026, 0.00056, 0.00025, 
	0.00017, 0.00014, 0.00035, 0.00008, 0.00019, 0.00004, 0.00011, 0.00010, 
	0.00031, 0.00051, 0.00014, 0.00018, 0.00001, 0.00085, 0.00133, 0.00057, 
	0.00008, 0.00018, 0.00008, 0.00024, 0.00020, 0.00006, 0.00009, 0.00001, 
	0.00002, 0.00001, 0.00004, 0.00001, 0.00001, 0.00001, 0.00008, 0.00000, 
	0.00000, 0.00002, 0.00001, 0.00000, 0.00009, 0.00002, 0.00000, 0.00007, 
	0.00004, 0.00001, 0.00003, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00012, 0.00000, 0.00000, 0.00000, 0.00006, 0.00000, 0.00000, 0.00001, 
	0.00006, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00005, 0.00000, 
	0.00000, 0.00006, 0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00008, 0.00000, 0.00000, 0.00001, 0.00006, 0.00000, 
	0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00011, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00056, 0.00027, 0.00070, 0.00021, 
	0.00033, 0.00054, 0.00033, 0.00002, 0.00001, 0.00002, 0.00022, 0.00007, 
	0.00028, 0.00311, 0.00018, 0.00024, 0.00005, 0.00006, 0.00079, 0.00059, 
	0.00003, 0.00055, 0.00002, 0.00005, 0.00002, 0.00010, 0.00003, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00008, 0.00001, 0.00001, 0.00000, 0.00005, 0.00001, 0.00000, 0.00002, 
	0.00008, 0.00000, 0.00000, 0.00001, 0.00001, 0.00001, 0.00005, 0.00001, 
	0.00000, 0.00001, 0.00006, 0.00001, 0.00001, 0.00000, 0.00001, 0.00000, 
	0.00001, 0.00000, 0.00061, 0.00009, 0.00010, 0.00005, 0.00105, 0.00006, 
	0.00004, 0.00004, 0.00052, 0.00001, 0.00001, 0.00002, 0.00008, 0.00006, 
	0.00039, 0.00016, 0.00000, 0.00004, 0.00026, 0.00009, 0.00008, 0.00001, 
	0.00004, 0.00000, 0.00025, 0.00001, 0.00028, 0.00001, 0.00001, 0.00001, 
	0.00022, 0.00001, 0.00001, 0.00001, 0.00008, 0.00000, 0.00000, 0.00001, 
	0.00001, 0.00000, 0.00013, 0.00001, 0.00000, 0.00001, 0.00007, 0.00001, 
	0.00005, 0.00000, 0.00001, 0.00000, 0.00002, 0.00000, 0.00005, 0.00000, 
	0.00000, 0.00000, 0.00015, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00036, 0.00031, 0.00038, 0.00008, 0.00004, 0.00007, 0.00204, 0.00003, 
	0.00006, 0.00004, 0.00005, 0.00008, 0.00011, 0.00044, 0.00024, 0.00015, 
	0.00001, 0.00041, 0.00032, 0.00027, 0.00028, 0.00043, 0.00030, 0.00001, 
	0.00005, 0.00001, 0.00020, 0.00000, 0.00001, 0.00001, 0.00007, 0.00001, 
	0.00000, 0.00009, 0.00005, 0.00000, 0.00000, 0.00005, 0.00001, 0.00000, 
	0.00009, 0.00000, 0.00000, 0.00010, 0.00002, 0.00001, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00004, 0.00000, 
	0.00000, 0.00000, 0.00011, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 
	0.00012, 0.00003, 0.00007, 0.00002, 0.00019, 0.00003, 0.00002, 0.00010, 
	0.00007, 0.00000, 0.00005, 0.00002, 0.00003, 0.00001, 0.00013, 0.00008, 
	0.00000, 0.00002, 0.00002, 0.00017, 0.00006, 0.00001, 0.00003, 0.00000, 
	0.00002, 0.00000, 0.00017, 0.00001, 0.00002, 0.00004, 0.00023, 0.00001, 
	0.00001, 0.00042, 0.00028, 0.00000, 0.00000, 0.00001, 0.00002, 0.00001, 
	0.00015, 0.00001, 0.00000, 0.00015, 0.00007, 0.00001, 0.00014, 0.00002, 
	0.00002, 0.00000, 0.00007, 0.00001, 0.00002, 0.00053, 0.00013, 0.00005, 
	0.00025, 0.00001, 0.00010, 0.00000, 0.00003, 0.00001, 0.00003, 0.00005, 
	0.00013, 0.00010, 0.00002, 0.00003, 0.00000, 0.00004, 0.00039, 0.00037, 
	0.00000, 0.00002, 0.00001, 0.00013, 0.00000, 0.00002, 0.00006, 0.00000, 
	0.00000, 0.00000, 0.00013, 0.00000, 0.00000, 0.00000, 0.00009, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00008, 0.00000, 0.00000, 0.00000, 0.00008, 0.00000, 0.00000, 0.00001, 
	0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00007, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00007, 0.00005, 0.00007, 0.00004, 
	0.00004, 0.00005, 0.00004, 0.00003, 0.00003, 0.00001, 0.00001, 0.00003, 
	0.00008, 0.00008, 0.00005, 0.00005, 0.00000, 0.00006, 0.00013, 0.00009, 
	0.00001, 0.00001, 0.00007, 0.00000, 0.00000, 0.00001, 0.00001, 0.00001, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00005, 0.00005, 0.00036, 0.00033, 0.00005, 0.00005, 0.00085, 0.00011, 
	0.00060, 0.00006, 0.00030, 0.00051, 0.00020, 0.00134, 0.00003, 0.00016, 
	0.00002, 0.00191, 0.00073, 0.00089, 0.00006, 0.00004, 0.00003, 0.00022, 
	0.00009, 0.00012, 0.00017, 0.00001, 0.00001, 0.00001, 0.00019, 0.00000, 
	0.00000, 0.00001, 0.00015, 0.00000, 0.00000, 0.00055, 0.00001, 0.00000, 
	0.00012, 0.00000, 0.00000, 0.00008, 0.00002, 0.00001, 0.00007, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00007, 0.00001, 0.00002, 0.00002, 
	0.00002, 0.00000, 0.00001, 0.00004, 0.00002, 0.00000, 0.00001, 0.00003, 
	0.00001, 0.00001, 0.00008, 0.00001, 0.00000, 0.00002, 0.00001, 0.00001, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00001, 
	0.00000, 0.00000, 0.00005, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00006, 0.00000, 0.00000, 0.00001, 
	0.00001, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00013, 0.00012, 0.00014, 0.00115, 0.00011, 0.00009, 0.00022, 0.00006, 
	0.00017, 0.00003, 0.00004, 0.00025, 0.00022, 0.00109, 0.00007, 0.00011, 
	0.00001, 0.00099, 0.00104, 0.00054, 0.00005, 0.00003, 0.00005, 0.00011, 
	0.00003, 0.00004, 0.00003, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00001, 0.00000, 0.00003, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00006, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 0.00001, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00001, 
	0.00001, 0.00000, 0.00001, 0.00001, 0.00000, 0.00004, 0.00001, 0.00001, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00001, 0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00005, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00012, 0.00002, 0.00038, 0.00012, 0.00014, 0.00002, 0.00009, 0.00005, 
	0.00001, 0.00002, 0.00009, 0.00053, 0.00004, 0.00101, 0.00004, 0.00002, 
	0.00001, 0.00019, 0.00033, 0.00032, 0.00006, 0.00001, 0.00001, 0.00010, 
	0.00002, 0.00008, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00001, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 0.00001, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00010, 0.00001, 
	0.00001, 0.00000, 0.00004, 0.00000, 0.00001, 0.00000, 0.00005, 0.00000, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00001, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00017, 0.00000, 0.00001, 0.00000, 0.00029, 0.00000, 0.00000, 0.00000, 
	0.00012, 0.00000, 0.00000, 0.00001, 0.00001, 0.00000, 0.00015, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00001, 0.00012, 0.00000, 0.00000, 0.00000, 
	0.00010, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 0.00006, 0.00000, 
	0.00000, 0.00000, 0.00005, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00046, 0.00009, 0.00039, 
	0.00005, 0.00003, 0.00004, 0.00004, 0.00005, 0.00005, 0.00006, 0.00008, 
	0.00029, 0.00098, 0.00012, 0.00003, 0.00000, 0.00040, 0.00023, 0.00046, 
	0.00017, 0.00046, 0.00004, 0.00001, 0.00002, 0.00003, 0.00034, 0.00001, 
	0.00002, 0.00001, 0.00014, 0.00002, 0.00001, 0.00004, 0.00014, 0.00000, 
	0.00001, 0.00043, 0.00001, 0.00001, 0.00027, 0.00001, 0.00000, 0.00020, 
	0.00008, 0.00005, 0.00018, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00004, 0.00001, 0.00001, 0.00001, 0.00006, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00003, 0.00001, 0.00000, 0.00000, 0.00002, 0.00001, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00006, 0.00002, 0.00005, 0.00002, 
	0.00007, 0.00002, 0.00002, 0.00006, 0.00004, 0.00000, 0.00003, 0.00002, 
	0.00003, 0.00002, 0.00007, 0.00005, 0.00000, 0.00001, 0.00002, 0.00014, 
	0.00005, 0.00001, 0.00002, 0.00000, 0.00001, 0.00000, 0.00003, 0.00001, 
	0.00000, 0.00000, 0.00005, 0.00000, 0.00001, 0.00003, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00001, 0.00004, 0.00000, 0.00000, 0.00005, 
	0.00001, 0.00000, 0.00003, 0.00002, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00003, 0.00001, 0.00003, 0.00003, 0.00004, 0.00001, 0.00002, 0.00001, 
	0.00001, 0.00002, 0.00002, 0.00018, 0.00006, 0.00030, 0.00000, 0.00001, 
	0.00000, 0.00009, 0.00167, 0.00006, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 
	0.00004, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00008, 0.00011, 0.00010, 0.00006, 0.00004, 0.00008, 0.00004, 0.00005, 
	0.00004, 0.00001, 0.00002, 0.00007, 0.00007, 0.00004, 0.00004, 0.00010, 
	0.00000, 0.00004, 0.00022, 0.00009, 0.00002, 0.00002, 0.00006, 0.00000, 
	0.00001, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00006, 0.00013, 0.00020, 0.00025, 
	0.00004, 0.00006, 0.00022, 0.00007, 0.00018, 0.00004, 0.00013, 0.00078, 
	0.00033, 0.00048, 0.00003, 0.00018, 0.00001, 0.00041, 0.00031, 0.00070, 
	0.00012, 0.00016, 0.00005, 0.00001, 0.00004, 0.00004, 0.00016, 0.00001, 
	0.00001, 0.00001, 0.00011, 0.00000, 0.00000, 0.00000, 0.00007, 0.00000, 
	0.00000, 0.00017, 0.00000, 0.00000, 0.00014, 0.00000, 0.00000, 0.00005, 
	0.00000, 0.00000, 0.00011, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00027, 0.00000, 0.00001, 0.00001, 0.00107, 0.00000, 0.00000, 0.00035, 
	0.00034, 0.00000, 0.00001, 0.00011, 0.00001, 0.00001, 0.00045, 0.00001, 
	0.00000, 0.00008, 0.00001, 0.00004, 0.00008, 0.00000, 0.00000, 0.00000, 
	0.00011, 0.00000, 0.00064, 0.00015, 0.00014, 0.00005, 0.00101, 0.00009, 
	0.00007, 0.00009, 0.00089, 0.00003, 0.00002, 0.00013, 0.00014, 0.00005, 
	0.00069, 0.00010, 0.00001, 0.00036, 0.00048, 0.00014, 0.00016, 0.00003, 
	0.00007, 0.00000, 0.00014, 0.00002, 0.00020, 0.00011, 0.00033, 0.00019, 
	0.00016, 0.00011, 0.00015, 0.00009, 0.00009, 0.00006, 0.00007, 0.00030, 
	0.00026, 0.00021, 0.00012, 0.00015, 0.00001, 0.00102, 0.00126, 0.00187, 
	0.00012, 0.00009, 0.00125, 0.00020, 0.00036, 0.00005, 0.00011, 0.00000, 
	0.00001, 0.00000, 0.00009, 0.00000, 0.00000, 0.00000, 0.00017, 0.00000, 
	0.00000, 0.00006, 0.00000, 0.00000, 0.00075, 0.00000, 0.00000, 0.00009, 
	0.00000, 0.00001, 0.00005, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00044, 0.00017, 0.00021, 0.00014, 0.00068, 0.00014, 0.00010, 0.00014, 
	0.00028, 0.00005, 0.00008, 0.00034, 0.00018, 0.00008, 0.00027, 0.00016, 
	0.00001, 0.00021, 0.00066, 0.00026, 0.00017, 0.00004, 0.00012, 0.00002, 
	0.00005, 0.00003, 0.00020, 0.00000, 0.00000, 0.00002, 0.00010, 0.00000, 
	0.00000, 0.00001, 0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 
	0.00019, 0.00000, 0.00000, 0.00000, 0.00001, 0.00001, 0.00005, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00040, 0.00005, 0.00067, 0.00007, 
	0.00025, 0.00009, 0.00016, 0.00003, 0.00002, 0.00002, 0.00023, 0.00008, 
	0.00027, 0.00067, 0.00019, 0.00008, 0.00005, 0.00005, 0.00037, 0.00051, 
	0.00006, 0.00019, 0.00002, 0.00007, 0.00003, 0.00005, 0.00011, 0.00000, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 0.00004, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00007, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00019, 0.00004, 0.00004, 0.00003, 0.00021, 0.00003, 0.00002, 0.00003, 
	0.00020, 0.00001, 0.00001, 0.00005, 0.00003, 0.00002, 0.00012, 0.00004, 
	0.00000, 0.00004, 0.00026, 0.00005, 0.00004, 0.00001, 0.00002, 0.00000, 
	0.00006, 0.00001, 0.00015, 0.00000, 0.00000, 0.00000, 0.00009, 0.00000, 
	0.00000, 0.00000, 0.00155, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00031, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00000, 0.00008, 0.00000, 0.00025, 0.00000, 0.00001, 0.00000, 
	0.00017, 0.00000, 0.00000, 0.00000, 0.00007, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00014, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00005, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 0.00021, 0.00001, 
	0.00001, 0.00001, 0.00063, 0.00000, 0.00001, 0.00001, 0.00020, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00014, 0.00001, 0.00000, 0.00000, 
	0.00003, 0.00001, 0.00007, 0.00000, 0.00000, 0.00000, 0.00019, 0.00000, 
	0.00004, 0.00009, 0.00009, 0.00008, 0.00004, 0.00008, 0.00006, 0.00002, 
	0.00008, 0.00001, 0.00006, 0.00020, 0.00020, 0.00023, 0.00008, 0.00008, 
	0.00000, 0.00030, 0.00026, 0.00036, 0.00008, 0.00029, 0.00032, 0.00003, 
	0.00004, 0.00002, 0.00018, 0.00000, 0.00001, 0.00000, 0.00005, 0.00000, 
	0.00000, 0.00003, 0.00005, 0.00000, 0.00000, 0.00006, 0.00000, 0.00000, 
	0.00015, 0.00000, 0.00000, 0.00013, 0.00001, 0.00000, 0.00004, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00006, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00007, 0.00000, 
	0.00000, 0.00000, 0.00016, 0.00000, 0.00000, 0.00000, 0.00006, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00006, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00024, 0.00007, 0.00014, 0.00004, 0.00041, 0.00008, 0.00003, 0.00021, 
	0.00035, 0.00001, 0.00008, 0.00007, 0.00006, 0.00003, 0.00026, 0.00023, 
	0.00001, 0.00002, 0.00004, 0.00061, 0.00032, 0.00002, 0.00008, 0.00000, 
	0.00003, 0.00001, 0.00088, 0.00006, 0.00010, 0.00006, 0.00170, 0.00005, 
	0.00005, 0.00026, 0.00064, 0.00002, 0.00001, 0.00008, 0.00007, 0.00003, 
	0.00054, 0.00008, 0.00000, 0.00072, 0.00050, 0.00006, 0.00037, 0.00006, 
	0.00005, 0.00001, 0.00010, 0.00002, 0.00008, 0.00002, 0.00002, 0.00010, 
	0.00009, 0.00002, 0.00001, 0.00000, 0.00001, 0.00000, 0.00002, 0.00003, 
	0.00010, 0.00012, 0.00001, 0.00003, 0.00000, 0.00005, 0.00013, 0.00014, 
	0.00000, 0.00001, 0.00000, 0.00005, 0.00000, 0.00000, 0.00006, 0.00000, 
	0.00000, 0.00000, 0.00030, 0.00000, 0.00000, 0.00000, 0.00015, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00009, 0.00000, 0.00000, 0.00000, 0.00014, 0.00000, 0.00000, 0.00002, 
	0.00006, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00011, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00001, 0.00000, 
	0.00000, 0.00002, 0.00000, 0.00000, 0.00012, 0.00003, 0.00007, 0.00002, 
	0.00002, 0.00002, 0.00002, 0.00002, 0.00002, 0.00001, 0.00001, 0.00003, 
	0.00005, 0.00001, 0.00007, 0.00003, 0.00000, 0.00001, 0.00006, 0.00005, 
	0.00002, 0.00001, 0.00002, 0.00001, 0.00000, 0.00000, 0.00009, 0.00001, 
	0.00000, 0.00000, 0.00007, 0.00000, 0.00000, 0.00002, 0.00004, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00001, 0.00011, 0.00042, 0.00000, 0.00001, 0.00002, 0.00001, 
	0.00002, 0.00000, 0.00003, 0.00009, 0.00004, 0.00013, 0.00001, 0.00004, 
	0.00000, 0.00020, 0.00009, 0.00007, 0.00003, 0.00001, 0.00000, 0.00001, 
	0.00000, 0.00001, 0.00042, 0.00009, 0.00002, 0.00002, 0.00022, 0.00001, 
	0.00001, 0.00001, 0.00054, 0.00002, 0.00001, 0.00013, 0.00002, 0.00001, 
	0.00021, 0.00001, 0.00000, 0.00010, 0.00029, 0.00002, 0.00012, 0.00001, 
	0.00001, 0.00000, 0.00002, 0.00001, 0.00041, 0.00001, 0.00009, 0.00001, 
	0.00014, 0.00000, 0.00000, 0.00025, 0.00045, 0.00000, 0.00056, 0.00008, 
	0.00001, 0.00002, 0.00032, 0.00001, 0.00000, 0.00007, 0.00003, 0.00010, 
	0.00011, 0.00000, 0.00000, 0.00000, 0.00001, 0.00001, 0.00040, 0.00004, 
	0.00004, 0.00006, 0.00081, 0.00003, 0.00005, 0.00003, 0.00028, 0.00001, 
	0.00001, 0.00005, 0.00003, 0.00005, 0.00023, 0.00003, 0.00000, 0.00007, 
	0.00014, 0.00003, 0.00020, 0.00001, 0.00003, 0.00000, 0.00013, 0.00002, 
	0.00001, 0.00003, 0.00002, 0.00004, 0.00000, 0.00001, 0.00001, 0.00001, 
	0.00001, 0.00000, 0.00003, 0.00006, 0.00006, 0.00011, 0.00000, 0.00002, 
	0.00000, 0.00006, 0.00017, 0.00004, 0.00001, 0.00002, 0.00000, 0.00004, 
	0.00001, 0.00001, 0.00014, 0.00003, 0.00004, 0.00002, 0.00013, 0.00039, 
	0.00002, 0.00002, 0.00032, 0.00001, 0.00001, 0.00006, 0.00005, 0.00002, 
	0.00011, 0.00003, 0.00000, 0.00006, 0.00006, 0.00058, 0.00004, 0.00001, 
	0.00003, 0.00000, 0.00001, 0.00000, 0.00023, 0.00003, 0.00003, 0.00007, 
	0.00014, 0.00016, 0.00022, 0.00003, 0.00035, 0.00001, 0.00001, 0.00014, 
	0.00003, 0.00004, 0.00022, 0.00002, 0.00000, 0.00034, 0.00017, 0.00004, 
	0.00009, 0.00001, 0.00003, 0.00000, 0.00013, 0.00001, 0.00010, 0.00001, 
	0.00000, 0.00001, 0.00005, 0.00000, 0.00000, 0.00000, 0.00005, 0.00000, 
	0.00000, 0.00001, 0.00002, 0.00010, 0.00012, 0.00000, 0.00000, 0.00001, 
	0.00001, 0.00001, 0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00001, 0.00011, 0.00019, 0.00001, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00007, 0.00004, 0.00039, 0.00001, 0.00003, 
	0.00000, 0.00006, 0.00013, 0.00009, 0.00000, 0.00001, 0.00000, 0.00001, 
	0.00000, 0.00001, 0.00008, 0.00000, 0.00000, 0.00000, 0.00020, 0.00000, 
	0.00000, 0.00000, 0.00005, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00007, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00015, 0.00003, 0.00003, 0.00002, 
	0.00031, 0.00002, 0.00001, 0.00002, 0.00019, 0.00000, 0.00002, 0.00004, 
	0.00017, 0.00003, 0.00013, 0.00002, 0.00000, 0.00003, 0.00017, 0.00005, 
	0.00014, 0.00001, 0.00001, 0.00000, 0.00006, 0.00000, 0.00044, 0.00004, 
	0.00005, 0.00038, 0.00039, 0.00012, 0.00005, 0.00003, 0.00069, 0.00001, 
	0.00007, 0.00059, 0.00005, 0.00004, 0.00067, 0.00004, 0.00000, 0.00001, 
	0.00026, 0.00008, 0.00040, 0.00005, 0.00001, 0.00000, 0.00008, 0.00002, 
	0.00076, 0.00020, 0.00005, 0.00004, 0.00118, 0.00005, 0.00004, 0.00003, 
	0.00038, 0.00001, 0.00002, 0.00008, 0.00047, 0.00006, 0.00045, 0.00055, 
	0.00000, 0.00003, 0.00022, 0.00007, 0.00124, 0.00002, 0.00003, 0.00001, 
	0.00004, 0.00001, 0.00081, 0.00015, 0.00037, 0.00063, 0.00157, 0.00021, 
	0.00051, 0.00009, 0.00060, 0.00004, 0.00010, 0.00150, 0.00015, 0.00030, 
	0.00030, 0.00017, 0.00002, 0.00010, 0.00144, 0.00087, 0.00009, 0.00013, 
	0.00011, 0.00001, 0.00016, 0.00004, 0.00001, 0.00008, 0.00003, 0.00058, 
	0.00001, 0.00006, 0.00012, 0.00001, 0.00001, 0.00001, 0.00091, 0.00059, 
	0.00032, 0.00025, 0.00004, 0.00015, 0.00000, 0.00020, 0.00013, 0.00031, 
	0.00001, 0.00003, 0.00001, 0.00001, 0.00001, 0.00003, 0.00026, 0.00005, 
	0.00007, 0.00005, 0.00062, 0.00004, 0.00003, 0.00010, 0.00027, 0.00001, 
	0.00002, 0.00020, 0.00008, 0.00003, 0.00024, 0.00023, 0.00000, 0.00017, 
	0.00019, 0.00025, 0.00009, 0.00001, 0.00003, 0.00000, 0.00005, 0.00001, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00006, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00064, 0.00011, 0.00020, 0.00109, 0.00138, 0.00008, 
	0.00026, 0.00005, 0.00070, 0.00003, 0.00073, 0.00068, 0.00049, 0.00088, 
	0.00030, 0.00022, 0.00001, 0.00025, 0.00046, 0.00174, 0.00062, 0.00003, 
	0.00007, 0.00001, 0.00060, 0.00003, 0.00026, 0.00005, 0.00018, 0.00011, 
	0.00041, 0.00004, 0.00004, 0.00027, 0.00023, 0.00001, 0.00006, 0.00005, 
	0.00017, 0.00004, 0.00019, 0.00024, 0.00001, 0.00003, 0.00029, 0.00129, 
	0.00010, 0.00003, 0.00004, 0.00001, 0.00006, 0.00002, 0.00036, 0.00011, 
	0.00007, 0.00003, 0.00078, 0.00003, 0.00002, 0.00028, 0.00047, 0.00001, 
	0.00002, 0.00005, 0.00005, 0.00003, 0.00091, 0.00004, 0.00000, 0.00015, 
	0.00018, 0.00028, 0.00010, 0.00004, 0.00003, 0.00000, 0.00004, 0.00001, 
	0.00003, 0.00005, 0.00011, 0.00017, 0.00003, 0.00002, 0.00011, 0.00002, 
	0.00004, 0.00002, 0.00004, 0.00013, 0.00003, 0.00069, 0.00001, 0.00056, 
	0.00001, 0.00126, 0.00058, 0.00155, 0.00000, 0.00004, 0.00002, 0.00002, 
	0.00001, 0.00002, 0.00027, 0.00000, 0.00001, 0.00001, 0.00087, 0.00000, 
	0.00000, 0.00000, 0.00058, 0.00000, 0.00001, 0.00001, 0.00001, 0.00002, 
	0.00010, 0.00001, 0.00000, 0.00001, 0.00003, 0.00001, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00012, 0.00004, 0.00004, 0.00005, 
	0.00055, 0.00002, 0.00001, 0.00003, 0.00008, 0.00001, 0.00001, 0.00007, 
	0.00003, 0.00048, 0.00012, 0.00004, 0.00000, 0.00002, 0.00015, 0.00011, 
	0.00001, 0.00001, 0.00001, 0.00000, 0.00003, 0.00000, 0.00002, 0.00001, 
	0.00002, 0.00001, 0.00002, 0.00002, 0.00000, 0.00001, 0.00006, 0.00000, 
	0.00000, 0.00001, 0.00001, 0.00001, 0.00002, 0.00001, 0.00000, 0.00001, 
	0.00002, 0.00001, 0.00000, 0.00000, 0.00000, 0.00002, 0.00008, 0.00000, 
	0.00018, 0.00001, 0.00002, 0.00002, 0.00005, 0.00001, 0.00001, 0.00000, 
	0.00001, 0.00000, 0.00001, 0.00001, 0.00003, 0.00001, 0.00008, 0.00002, 
	0.00000, 0.00001, 0.00012, 0.00003, 0.00007, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00001, 0.00006, 0.00002, 0.00000, 0.00002, 0.00005, 0.00000, 
	0.00001, 0.00001, 0.00004, 0.00000, 0.00000, 0.00001, 0.00001, 0.00002, 
	0.00004, 0.00000, 0.00000, 0.00000, 0.00001, 0.00001, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00001, 0.00002, 0.00003, 0.00037, 0.00015, 
	0.00001, 0.00001, 0.00033, 0.00002, 0.00023, 0.00001, 0.00010, 0.00025, 
	0.00006, 0.00059, 0.00002, 0.00025, 0.00001, 0.00121, 0.00031, 0.00028, 
	0.00008, 0.00002, 0.00003, 0.00001, 0.00022, 0.00003, 0.00003, 0.00001, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00003, 0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00001, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00006, 0.00001, 0.00001, 0.00001, 0.00002, 0.00001, 0.00001, 0.00004, 
	0.00003, 0.00000, 0.00000, 0.00003, 0.00001, 0.00001, 0.00008, 0.00001, 
	0.00000, 0.00002, 0.00002, 0.00001, 0.00001, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00007, 0.00000, 0.00000, 0.00000, 0.00005, 0.00004, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00003, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00016, 0.00002, 0.00018, 0.00017, 
	0.00013, 0.00001, 0.00003, 0.00001, 0.00003, 0.00001, 0.00002, 0.00018, 
	0.00004, 0.00045, 0.00009, 0.00007, 0.00001, 0.00161, 0.00017, 0.00028, 
	0.00002, 0.00001, 0.00001, 0.00003, 0.00001, 0.00002, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00002, 0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00002, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00003, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00003, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00017, 0.00000, 0.00000, 0.00001, 0.00010, 0.00000, 
	0.00000, 0.00000, 0.00026, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00059, 0.00009, 0.00000, 0.00001, 0.00001, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00000, 0.00010, 0.00000, 0.00011, 0.00001, 0.00039, 0.00009, 
	0.00017, 0.00005, 0.00003, 0.00000, 0.00001, 0.00000, 0.00003, 0.00011, 
	0.00003, 0.00060, 0.00006, 0.00004, 0.00000, 0.00024, 0.00008, 0.00022, 
	0.00001, 0.00001, 0.00000, 0.00013, 0.00000, 0.00004, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00115, 0.00000, 0.00001, 0.00000, 0.00048, 0.00000, 
	0.00000, 0.00000, 0.00021, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00020, 0.00000, 0.00000, 0.00002, 0.00001, 0.00000, 0.00033, 0.00000, 
	0.00000, 0.00000, 0.00011, 0.00000, 0.00008, 0.00000, 0.00001, 0.00000, 
	0.00008, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00006, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00002, 0.00006, 0.00011, 0.00004, 0.00002, 0.00002, 0.00001, 
	0.00018, 0.00001, 0.00012, 0.00036, 0.00004, 0.00035, 0.00010, 0.00016, 
	0.00000, 0.00199, 0.00042, 0.00026, 0.00006, 0.00003, 0.00030, 0.00000, 
	0.00000, 0.00003, 0.00007, 0.00001, 0.00002, 0.00001, 0.00021, 0.00001, 
	0.00001, 0.00002, 0.00019, 0.00000, 0.00000, 0.00023, 0.00001, 0.00001, 
	0.00014, 0.00001, 0.00000, 0.00006, 0.00015, 0.00002, 0.00001, 0.00001, 
	0.00000, 0.00000, 0.00012, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00026, 0.00000, 
	0.00001, 0.00001, 0.00159, 0.00000, 0.00000, 0.00000, 0.00072, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00001, 0.00192, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00001, 0.00004, 0.00000, 0.00001, 0.00000, 0.00001, 0.00002, 
	0.00005, 0.00001, 0.00004, 0.00003, 0.00008, 0.00002, 0.00001, 0.00006, 
	0.00008, 0.00000, 0.00002, 0.00001, 0.00002, 0.00002, 0.00007, 0.00007, 
	0.00000, 0.00001, 0.00002, 0.00011, 0.00003, 0.00001, 0.00001, 0.00000, 
	0.00006, 0.00001, 0.00006, 0.00000, 0.00004, 0.00001, 0.00009, 0.00000, 
	0.00000, 0.00004, 0.00025, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00012, 0.00001, 0.00000, 0.00004, 0.00006, 0.00001, 0.00005, 0.00001, 
	0.00001, 0.00000, 0.00001, 0.00000, 0.00001, 0.00023, 0.00001, 0.00001, 
	0.00004, 0.00001, 0.00001, 0.00000, 0.00000, 0.00001, 0.00001, 0.00010, 
	0.00002, 0.00011, 0.00000, 0.00004, 0.00000, 0.00016, 0.00016, 0.00016, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00001, 0.00002, 0.00003, 
	0.00001, 0.00001, 0.00001, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 
	0.00002, 0.00000, 0.00001, 0.00001, 0.00000, 0.00002, 0.00002, 0.00003, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 0.00001, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00028, 0.00000, 0.00000, 0.00000, 0.00054, 0.00000, 0.00000, 0.00000, 
	0.00036, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00008, 0.00000, 
	0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00006, 0.00034, 0.00073, 0.00096, 
	0.00008, 0.00046, 0.00026, 0.00013, 0.00050, 0.00008, 0.00015, 0.00068, 
	0.00052, 0.00161, 0.00006, 0.00048, 0.00003, 0.00022, 0.00053, 0.00094, 
	0.00013, 0.00062, 0.00012, 0.00003, 0.00012, 0.00018, 0.00027, 0.00001, 
	0.00001, 0.00001, 0.00014, 0.00000, 0.00000, 0.00000, 0.00011, 0.00000, 
	0.00000, 0.00011, 0.00000, 0.00001, 0.00017, 0.00000, 0.00000, 0.00007, 
	0.00002, 0.00001, 0.00010, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00025, 0.00001, 0.00001, 0.00001, 0.00042, 0.00000, 0.00000, 0.00063, 
	0.00013, 0.00000, 0.00001, 0.00011, 0.00001, 0.00001, 0.00031, 0.00001, 
	0.00000, 0.00006, 0.00001, 0.00001, 0.00007, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00020, 0.00003, 0.00006, 0.00002, 0.00041, 0.00002, 
	0.00002, 0.00002, 0.00025, 0.00001, 0.00001, 0.00003, 0.00003, 0.00002, 
	0.00013, 0.00059, 0.00000, 0.00006, 0.00029, 0.00003, 0.00005, 0.00001, 
	0.00004, 0.00000, 0.00002, 0.00001, 0.00150, 0.00016, 0.00112, 0.00076, 
	0.00158, 0.00024, 0.00031, 0.00010, 0.00029, 0.00003, 0.00012, 0.00036, 
	0.00046, 0.00111, 0.00007, 0.00046, 0.00002, 0.00014, 0.00261, 0.00052, 
	0.00007, 0.00047, 0.00017, 0.00019, 0.00008, 0.00009, 0.00011, 0.00000, 
	0.00001, 0.00000, 0.00010, 0.00000, 0.00000, 0.00000, 0.00010, 0.00000, 
	0.00000, 0.00004, 0.00001, 0.00000, 0.00016, 0.00001, 0.00000, 0.00007, 
	0.00001, 0.00001, 0.00008, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00026, 0.00001, 0.00001, 0.00000, 0.00030, 0.00001, 0.00000, 0.00002, 
	0.00015, 0.00000, 0.00000, 0.00004, 0.00001, 0.00001, 0.00011, 0.00001, 
	0.00000, 0.00009, 0.00002, 0.00001, 0.00008, 0.00000, 0.00000, 0.00000, 
	0.00009, 0.00000, 0.00009, 0.00000, 0.00000, 0.00001, 0.00009, 0.00000, 
	0.00000, 0.00000, 0.00006, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00014, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00070, 0.00019, 0.00092, 0.00036, 
	0.00066, 0.00012, 0.00020, 0.00002, 0.00002, 0.00004, 0.00013, 0.00014, 
	0.00026, 0.00095, 0.00042, 0.00029, 0.00002, 0.00004, 0.00081, 0.00064, 
	0.00007, 0.00029, 0.00001, 0.00008, 0.00004, 0.00012, 0.00004, 0.00000, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00005, 0.00001, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00016, 0.00002, 0.00012, 0.00002, 0.00071, 0.00003, 0.00001, 0.00003, 
	0.00019, 0.00000, 0.00001, 0.00004, 0.00003, 0.00002, 0.00007, 0.00003, 
	0.00000, 0.00003, 0.00029, 0.00007, 0.00004, 0.00001, 0.00003, 0.00000, 
	0.00001, 0.00001, 0.00022, 0.00001, 0.00001, 0.00059, 0.00016, 0.00002, 
	0.00001, 0.00000, 0.00031, 0.00000, 0.00000, 0.00001, 0.00001, 0.00000, 
	0.00017, 0.00001, 0.00000, 0.00000, 0.00020, 0.00001, 0.00002, 0.00000, 
	0.00001, 0.00000, 0.00004, 0.00001, 0.00071, 0.00001, 0.00001, 0.00001, 
	0.00026, 0.00001, 0.00001, 0.00001, 0.00016, 0.00000, 0.00000, 0.00001, 
	0.00001, 0.00001, 0.00020, 0.00001, 0.00000, 0.00002, 0.00007, 0.00001, 
	0.00008, 0.00000, 0.00001, 0.00000, 0.00005, 0.00000, 0.00039, 0.00003, 
	0.00003, 0.00002, 0.00064, 0.00003, 0.00002, 0.00003, 0.00027, 0.00001, 
	0.00001, 0.00002, 0.00004, 0.00001, 0.00029, 0.00003, 0.00000, 0.00001, 
	0.00010, 0.00009, 0.00003, 0.00002, 0.00002, 0.00001, 0.00003, 0.00000, 
	0.00019, 0.00023, 0.00037, 0.00036, 0.00009, 0.00036, 0.00023, 0.00004, 
	0.00023, 0.00020, 0.00012, 0.00032, 0.00051, 0.00067, 0.00030, 0.00046, 
	0.00001, 0.00010, 0.00067, 0.00034, 0.00062, 0.00020, 0.00027, 0.00010, 
	0.00013, 0.00006, 0.00014, 0.00000, 0.00001, 0.00000, 0.00009, 0.00001, 
	0.00002, 0.00004, 0.00005, 0.00000, 0.00000, 0.00009, 0.00001, 0.00000, 
	0.00019, 0.00000, 0.00000, 0.00021, 0.00002, 0.00001, 0.00003, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00005, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00022, 0.00000, 
	0.00000, 0.00000, 0.00041, 0.00000, 0.00000, 0.00001, 0.00020, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00018, 0.00000, 0.00000, 0.00001, 
	0.00001, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 0.00013, 0.00000, 
	0.00025, 0.00005, 0.00014, 0.00005, 0.00041, 0.00004, 0.00003, 0.00022, 
	0.00032, 0.00001, 0.00005, 0.00005, 0.00006, 0.00003, 0.00030, 0.00014, 
	0.00001, 0.00003, 0.00006, 0.00039, 0.00010, 0.00002, 0.00005, 0.00000, 
	0.00003, 0.00001, 0.00056, 0.00007, 0.00008, 0.00004, 0.00050, 0.00006, 
	0.00006, 0.00033, 0.00059, 0.00001, 0.00002, 0.00008, 0.00010, 0.00014, 
	0.00029, 0.00008, 0.00000, 0.00016, 0.00063, 0.00005, 0.00030, 0.00005, 
	0.00005, 0.00000, 0.00023, 0.00002, 0.00002, 0.00007, 0.00014, 0.00004, 
	0.00009, 0.00002, 0.00010, 0.00002, 0.00012, 0.00001, 0.00004, 0.00005, 
	0.00071, 0.00026, 0.00001, 0.00013, 0.00000, 0.00004, 0.00040, 0.00011, 
	0.00005, 0.00001, 0.00001, 0.00001, 0.00002, 0.00004, 0.00011, 0.00000, 
	0.00001, 0.00000, 0.00036, 0.00000, 0.00000, 0.00000, 0.00048, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00011, 0.00000, 0.00000, 0.00000, 0.00012, 0.00000, 0.00000, 0.00002, 
	0.00006, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00011, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00010, 0.00006, 0.00007, 0.00006, 
	0.00003, 0.00004, 0.00003, 0.00003, 0.00002, 0.00001, 0.00002, 0.00005, 
	0.00005, 0.00003, 0.00013, 0.00007, 0.00000, 0.00003, 0.00013, 0.00008, 
	0.00002, 0.00001, 0.00004, 0.00000, 0.00000, 0.00001, 0.00003, 0.00000, 
	0.00000, 0.00000, 0.00008, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00001, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00006, 0.00014, 0.00012, 0.00016, 0.00003, 0.00017, 0.00014, 0.00006, 
	0.00017, 0.00002, 0.00009, 0.00059, 0.00028, 0.00076, 0.00004, 0.00011, 
	0.00001, 0.00029, 0.00018, 0.00023, 0.00012, 0.00018, 0.00004, 0.00001, 
	0.00007, 0.00002, 0.00016, 0.00001, 0.00001, 0.00001, 0.00010, 0.00000, 
	0.00001, 0.00000, 0.00008, 0.00000, 0.00000, 0.00014, 0.00001, 0.00001, 
	0.00013, 0.00000, 0.00000, 0.00007, 0.00001, 0.00000, 0.00009, 0.00000, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00043, 0.00001, 0.00001, 0.00001, 
	0.00012, 0.00000, 0.00001, 0.00079, 0.00018, 0.00000, 0.00000, 0.00015, 
	0.00001, 0.00001, 0.00084, 0.00001, 0.00000, 0.00030, 0.00001, 0.00001, 
	0.00012, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00011, 0.00001, 
	0.00001, 0.00000, 0.00036, 0.00001, 0.00000, 0.00000, 0.00016, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00001, 0.00010, 0.00000, 0.00000, 0.00003, 
	0.00001, 0.00001, 0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00048, 0.00009, 0.00039, 0.00017, 0.00019, 0.00005, 0.00010, 0.00006, 
	0.00013, 0.00002, 0.00006, 0.00039, 0.00021, 0.00061, 0.00046, 0.00011, 
	0.00001, 0.00244, 0.00032, 0.00025, 0.00008, 0.00009, 0.00007, 0.00063, 
	0.00007, 0.00001, 0.00011, 0.00000, 0.00001, 0.00000, 0.00007, 0.00000, 
	0.00000, 0.00000, 0.00010, 0.00000, 0.00000, 0.00003, 0.00001, 0.00000, 
	0.00022, 0.00000, 0.00000, 0.00010, 0.00000, 0.00000, 0.00005, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00011, 0.00000, 0.00000, 0.00000, 
	0.00005, 0.00000, 0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00003, 
	0.00000, 0.00000, 0.00006, 0.00000, 0.00000, 0.00012, 0.00001, 0.00000, 
	0.00006, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00072, 0.00006, 
	0.00006, 0.00004, 0.00044, 0.00004, 0.00004, 0.00002, 0.00090, 0.00001, 
	0.00006, 0.00004, 0.00006, 0.00003, 0.00161, 0.00005, 0.00001, 0.00005, 
	0.00005, 0.00008, 0.00015, 0.00002, 0.00003, 0.00000, 0.00002, 0.00000, 
	0.00044, 0.00007, 0.00048, 0.00024, 0.00014, 0.00012, 0.00073, 0.00002, 
	0.00001, 0.00000, 0.00006, 0.00026, 0.00034, 0.00114, 0.00051, 0.00006, 
	0.00001, 0.00009, 0.00025, 0.00088, 0.00001, 0.00010, 0.00001, 0.00003, 
	0.00001, 0.00004, 0.00003, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00005, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00017, 0.00001, 0.00001, 0.00001, 
	0.00011, 0.00001, 0.00001, 0.00001, 0.00031, 0.00000, 0.00000, 0.00004, 
	0.00001, 0.00001, 0.00011, 0.00001, 0.00000, 0.00003, 0.00002, 0.00003, 
	0.00005, 0.00001, 0.00000, 0.00000, 0.00017, 0.00000, 0.00030, 0.00000, 
	0.00001, 0.00000, 0.00015, 0.00000, 0.00000, 0.00000, 0.00030, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00015, 0.00000, 0.00000, 0.00001, 
	0.00001, 0.00001, 0.00005, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00061, 0.00001, 0.00002, 0.00001, 0.00025, 0.00001, 0.00001, 0.00000, 
	0.00017, 0.00000, 0.00000, 0.00001, 0.00001, 0.00001, 0.00027, 0.00001, 
	0.00000, 0.00001, 0.00012, 0.00002, 0.00006, 0.00000, 0.00000, 0.00000, 
	0.00004, 0.00000, 0.00013, 0.00001, 0.00001, 0.00000, 0.00023, 0.00000, 
	0.00001, 0.00000, 0.00007, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00014, 0.00000, 0.00000, 0.00000, 0.00001, 0.00001, 0.00003, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00004, 0.00005, 0.00043, 0.00004, 
	0.00001, 0.00065, 0.00002, 0.00003, 0.00002, 0.00001, 0.00004, 0.00056, 
	0.00012, 0.00091, 0.00003, 0.00006, 0.00000, 0.00028, 0.00011, 0.00005, 
	0.00042, 0.00005, 0.00002, 0.00000, 0.00002, 0.00002, 0.00062, 0.00003, 
	0.00002, 0.00001, 0.00046, 0.00001, 0.00001, 0.00008, 0.00038, 0.00000, 
	0.00002, 0.00017, 0.00001, 0.00001, 0.00089, 0.00000, 0.00000, 0.00031, 
	0.00002, 0.00001, 0.00005, 0.00000, 0.00000, 0.00000, 0.00005, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00014, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00008, 0.00001, 0.00001, 0.00000, 0.00021, 0.00000, 
	0.00000, 0.00000, 0.00005, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00007, 0.00000, 0.00000, 0.00000, 0.00001, 0.00001, 0.00004, 0.00001, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00031, 0.00007, 0.00012, 0.00005, 
	0.00052, 0.00008, 0.00004, 0.00010, 0.00070, 0.00001, 0.00003, 0.00007, 
	0.00009, 0.00004, 0.00029, 0.00013, 0.00001, 0.00006, 0.00006, 0.00018, 
	0.00010, 0.00001, 0.00007, 0.00000, 0.00011, 0.00001, 0.00205, 0.00012, 
	0.00016, 0.00009, 0.00174, 0.00012, 0.00007, 0.00016, 0.00116, 0.00003, 
	0.00003, 0.00014, 0.00017, 0.00008, 0.00143, 0.00012, 0.00001, 0.00126, 
	0.00024, 0.00008, 0.00071, 0.00008, 0.00008, 0.00001, 0.00035, 0.00000, 
	0.00007, 0.00020, 0.00012, 0.00005, 0.00004, 0.00001, 0.00005, 0.00001, 
	0.00007, 0.00001, 0.00006, 0.00019, 0.00017, 0.00028, 0.00002, 0.00050, 
	0.00000, 0.00046, 0.00014, 0.00003, 0.00000, 0.00001, 0.00001, 0.00000, 
	0.00001, 0.00003, 0.00005, 0.00000, 0.00000, 0.00000, 0.00010, 0.00000, 
	0.00000, 0.00000, 0.00011, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00003, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00014, 0.00000, 0.00000, 0.00000, 
	0.00029, 0.00000, 0.00000, 0.00002, 0.00019, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00021, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00006, 0.00003, 0.00008, 0.00003, 0.00002, 0.00002, 0.00001, 0.00001, 
	0.00001, 0.00000, 0.00001, 0.00003, 0.00005, 0.00008, 0.00006, 0.00002, 
	0.00000, 0.00003, 0.00028, 0.00003, 0.00001, 0.00001, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00001, 0.00000, 0.00004, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00005, 0.00031, 0.00030, 0.00022, 
	0.00005, 0.00010, 0.00031, 0.00007, 0.00038, 0.00003, 0.00019, 0.00154, 
	0.00029, 0.00075, 0.00007, 0.00018, 0.00001, 0.00097, 0.00047, 0.00057, 
	0.00012, 0.00008, 0.00005, 0.00008, 0.00008, 0.00003, 0.00022, 0.00001, 
	0.00000, 0.00001, 0.00007, 0.00000, 0.00000, 0.00000, 0.00007, 0.00000, 
	0.00000, 0.00009, 0.00000, 0.00000, 0.00014, 0.00000, 0.00000, 0.00005, 
	0.00001, 0.00000, 0.00009, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00019, 0.00001, 0.00001, 0.00001, 0.00005, 0.00000, 0.00000, 0.00053, 
	0.00004, 0.00000, 0.00000, 0.00009, 0.00001, 0.00001, 0.00036, 0.00001, 
	0.00000, 0.00005, 0.00001, 0.00001, 0.00003, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00006, 0.00000, 0.00001, 0.00000, 0.00014, 0.00000, 
	0.00000, 0.00000, 0.00010, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00011, 0.00000, 0.00000, 0.00003, 0.00001, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00044, 0.00015, 0.00108, 0.00039, 
	0.00032, 0.00008, 0.00015, 0.00008, 0.00015, 0.00002, 0.00018, 0.00093, 
	0.00058, 0.00070, 0.00010, 0.00018, 0.00001, 0.00317, 0.00103, 0.00014, 
	0.00013, 0.00009, 0.00008, 0.00023, 0.00003, 0.00002, 0.00008, 0.00000, 
	0.00001, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 0.00010, 0.00000, 
	0.00000, 0.00003, 0.00002, 0.00000, 0.00016, 0.00000, 0.00000, 0.00008, 
	0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00012, 0.00000, 0.00000, 0.00000, 0.00006, 0.00000, 0.00000, 0.00000, 
	0.00005, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00004, 0.00001, 
	0.00000, 0.00006, 0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00048, 0.00004, 0.00008, 0.00004, 0.00268, 0.00004, 
	0.00002, 0.00002, 0.00045, 0.00001, 0.00001, 0.00007, 0.00006, 0.00003, 
	0.00041, 0.00004, 0.00001, 0.00012, 0.00010, 0.00004, 0.00012, 0.00001, 
	0.00005, 0.00000, 0.00010, 0.00000, 0.00022, 0.00005, 0.00116, 0.00008, 
	0.00033, 0.00014, 0.00010, 0.00002, 0.00001, 0.00001, 0.00021, 0.00019, 
	0.00059, 0.00172, 0.00197, 0.00024, 0.00011, 0.00012, 0.00047, 0.00029, 
	0.00002, 0.00059, 0.00002, 0.00003, 0.00001, 0.00007, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00005, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00006, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00001, 
	0.00006, 0.00000, 0.00000, 0.00001, 0.00000, 0.00001, 0.00003, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00020, 0.00000, 0.00001, 0.00000, 0.00037, 0.00000, 
	0.00000, 0.00000, 0.00020, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00012, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00032, 0.00000, 0.00001, 0.00000, 
	0.00022, 0.00000, 0.00000, 0.00000, 0.00006, 0.00000, 0.00000, 0.00004, 
	0.00000, 0.00000, 0.00014, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00004, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 0.00008, 0.00000, 
	0.00000, 0.00000, 0.00039, 0.00000, 0.00001, 0.00000, 0.00005, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00006, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00001, 0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00007, 0.00017, 0.00026, 0.00030, 0.00007, 0.00016, 0.00019, 0.00005, 
	0.00008, 0.00002, 0.00016, 0.00016, 0.00038, 0.00070, 0.00033, 0.00068, 
	0.00001, 0.00230, 0.00045, 0.00020, 0.00039, 0.00008, 0.00019, 0.00002, 
	0.00014, 0.00002, 0.00014, 0.00000, 0.00001, 0.00000, 0.00005, 0.00000, 
	0.00000, 0.00004, 0.00005, 0.00000, 0.00000, 0.00010, 0.00000, 0.00000, 
	0.00011, 0.00000, 0.00000, 0.00017, 0.00001, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00231, 0.00000, 
	0.00001, 0.00000, 0.00103, 0.00000, 0.00000, 0.00000, 0.00085, 0.00000, 
	0.00001, 0.00001, 0.00000, 0.00001, 0.00084, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00001, 0.00037, 0.00000, 0.00000, 0.00000, 0.00016, 0.00001, 
	0.00016, 0.00006, 0.00018, 0.00005, 0.00021, 0.00005, 0.00004, 0.00016, 
	0.00012, 0.00001, 0.00004, 0.00004, 0.00008, 0.00004, 0.00019, 0.00013, 
	0.00001, 0.00003, 0.00004, 0.00023, 0.00018, 0.00002, 0.00005, 0.00000, 
	0.00006, 0.00001, 0.00018, 0.00001, 0.00001, 0.00001, 0.00060, 0.00001, 
	0.00001, 0.00008, 0.00020, 0.00000, 0.00001, 0.00014, 0.00001, 0.00001, 
	0.00025, 0.00002, 0.00000, 0.00013, 0.00004, 0.00001, 0.00007, 0.00002, 
	0.00001, 0.00000, 0.00008, 0.00000, 0.00017, 0.00140, 0.00005, 0.00039, 
	0.00005, 0.00008, 0.00004, 0.00001, 0.00006, 0.00001, 0.00003, 0.00005, 
	0.00053, 0.00021, 0.00002, 0.00010, 0.00000, 0.00110, 0.00021, 0.00022, 
	0.00001, 0.00001, 0.00001, 0.00001, 0.00001, 0.00001, 0.00005, 0.00001, 
	0.00002, 0.00001, 0.00005, 0.00001, 0.00001, 0.00000, 0.00009, 0.00000, 
	0.00000, 0.00001, 0.00001, 0.00002, 0.00005, 0.00002, 0.00000, 0.00001, 
	0.00004, 0.00002, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00024, 0.00000, 0.00000, 0.00000, 0.00020, 0.00000, 0.00000, 0.00001, 
	0.00017, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00052, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00007, 0.00007, 0.00010, 0.00004, 
	0.00003, 0.00005, 0.00005, 0.00003, 0.00003, 0.00001, 0.00002, 0.00031, 
	0.00007, 0.00005, 0.00009, 0.00014, 0.00000, 0.00005, 0.00011, 0.00007, 
	0.00001, 0.00001, 0.00004, 0.00000, 0.00000, 0.00001, 0.00002, 0.00001, 
	0.00001, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00001, 0.00001, 0.00000, 0.00001, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00002, 0.00002, 0.00005, 0.00002, 0.00001, 0.00003, 0.00001, 
	0.00006, 0.00001, 0.00001, 0.00030, 0.00002, 0.00019, 0.00000, 0.00002, 
	0.00000, 0.00020, 0.00003, 0.00007, 0.00001, 0.00001, 0.00001, 0.00000, 
	0.00002, 0.00001, 0.00014, 0.00007, 0.00002, 0.00002, 0.00149, 0.00001, 
	0.00001, 0.00001, 0.00009, 0.00000, 0.00001, 0.00027, 0.00009, 0.00001, 
	0.00005, 0.00003, 0.00000, 0.00003, 0.00008, 0.00002, 0.00005, 0.00001, 
	0.00001, 0.00000, 0.00002, 0.00000, 0.00016, 0.00000, 0.00009, 0.00000, 
	0.00007, 0.00000, 0.00000, 0.00025, 0.00007, 0.00000, 0.00032, 0.00002, 
	0.00000, 0.00000, 0.00007, 0.00000, 0.00000, 0.00002, 0.00001, 0.00023, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00012, 0.00001, 
	0.00001, 0.00006, 0.00026, 0.00001, 0.00004, 0.00001, 0.00043, 0.00000, 
	0.00000, 0.00001, 0.00001, 0.00001, 0.00009, 0.00001, 0.00000, 0.00002, 
	0.00004, 0.00001, 0.00002, 0.00000, 0.00001, 0.00000, 0.00005, 0.00001, 
	0.00002, 0.00008, 0.00006, 0.00007, 0.00006, 0.00002, 0.00010, 0.00003, 
	0.00002, 0.00001, 0.00001, 0.00015, 0.00005, 0.00015, 0.00001, 0.00004, 
	0.00000, 0.00018, 0.00025, 0.00007, 0.00001, 0.00003, 0.00002, 0.00001, 
	0.00001, 0.00001, 0.00004, 0.00000, 0.00001, 0.00000, 0.00002, 0.00013, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00003, 0.00000, 0.00000, 0.00001, 0.00001, 0.00001, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00016, 0.00002, 0.00001, 0.00000, 
	0.00008, 0.00000, 0.00005, 0.00010, 0.00006, 0.00000, 0.00000, 0.00002, 
	0.00001, 0.00000, 0.00004, 0.00000, 0.00000, 0.00002, 0.00004, 0.00000, 
	0.00007, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00005, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00001, 0.00003, 0.00000, 0.00000, 0.00001, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00006, 0.00001, 0.00011, 0.00031, 0.00002, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00022, 0.00002, 0.00011, 0.00001, 0.00004, 
	0.00000, 0.00004, 0.00015, 0.00027, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00000, 0.00003, 0.00003, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00000, 0.00005, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00009, 0.00001, 0.00001, 0.00000, 
	0.00007, 0.00000, 0.00000, 0.00001, 0.00006, 0.00000, 0.00002, 0.00001, 
	0.00001, 0.00001, 0.00003, 0.00001, 0.00000, 0.00003, 0.00002, 0.00003, 
	0.00006, 0.00000, 0.00001, 0.00000, 0.00001, 0.00000, 0.00030, 0.00003, 
	0.00003, 0.00003, 0.00013, 0.00004, 0.00002, 0.00002, 0.00015, 0.00000, 
	0.00004, 0.00024, 0.00003, 0.00001, 0.00009, 0.00002, 0.00000, 0.00001, 
	0.00008, 0.00060, 0.00005, 0.00001, 0.00001, 0.00000, 0.00001, 0.00001, 
	0.00023, 0.00063, 0.00003, 0.00002, 0.00022, 0.00002, 0.00002, 0.00002, 
	0.00010, 0.00000, 0.00001, 0.00002, 0.00011, 0.00003, 0.00010, 0.00013, 
	0.00000, 0.00002, 0.00015, 0.00003, 0.00004, 0.00001, 0.00002, 0.00000, 
	0.00001, 0.00001, 0.00015, 0.00004, 0.00023, 0.00071, 0.00021, 0.00004, 
	0.00041, 0.00002, 0.00072, 0.00002, 0.00013, 0.00011, 0.00003, 0.00016, 
	0.00007, 0.00003, 0.00000, 0.00003, 0.00013, 0.00052, 0.00002, 0.00001, 
	0.00002, 0.00000, 0.00003, 0.00001, 0.00000, 0.00001, 0.00001, 0.00001, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 0.00001, 0.00005, 
	0.00001, 0.00005, 0.00000, 0.00000, 0.00000, 0.00002, 0.00001, 0.00007, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00009, 0.00002, 
	0.00004, 0.00006, 0.00031, 0.00001, 0.00002, 0.00001, 0.00006, 0.00000, 
	0.00001, 0.00009, 0.00002, 0.00001, 0.00024, 0.00023, 0.00000, 0.00005, 
	0.00008, 0.00004, 0.00002, 0.00000, 0.00001, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00062, 0.00017, 0.00025, 0.00009, 0.00093, 0.00013, 
	0.00018, 0.00004, 0.00045, 0.00001, 0.00010, 0.00016, 0.00009, 0.00029, 
	0.00034, 0.00009, 0.00000, 0.00009, 0.00041, 0.00014, 0.00014, 0.00012, 
	0.00003, 0.00000, 0.00011, 0.00001, 0.00034, 0.00006, 0.00016, 0.00004, 
	0.00193, 0.00004, 0.00003, 0.00021, 0.00078, 0.00001, 0.00004, 0.00007, 
	0.00006, 0.00003, 0.00006, 0.00007, 0.00001, 0.00002, 0.00027, 0.00070, 
	0.00005, 0.00002, 0.00003, 0.00000, 0.00002, 0.00001, 0.00014, 0.00005, 
	0.00004, 0.00005, 0.00038, 0.00003, 0.00001, 0.00023, 0.00053, 0.00000, 
	0.00001, 0.00010, 0.00002, 0.00002, 0.00063, 0.00002, 0.00000, 0.00012, 
	0.00017, 0.00015, 0.00100, 0.00001, 0.00002, 0.00000, 0.00014, 0.00002, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00001, 0.00000, 0.00000, 
	0.00000, 0.00001, 0.00005, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 0.00007, 0.00000, 
	0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 
	0.00004, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00001, 
	0.00001, 0.00001, 0.00004, 0.00001, 0.00001, 0.00001, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00001, 0.00001, 0.00000, 0.00000, 
	0.00001, 0.00001, 0.00004, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00004, 0.00001, 0.00001, 0.00001, 0.00004, 0.00001, 0.00001, 0.00001, 
	0.00002, 0.00000, 0.00000, 0.00001, 0.00001, 0.00001, 0.00002, 0.00001, 
	0.00000, 0.00000, 0.00005, 0.00001, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00001, 0.00000, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00001, 0.00004, 0.00000, 0.00000, 0.00001, 0.00001, 0.00001, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00013, 0.00002, 0.00002, 0.00012, 0.00007, 
	0.00001, 0.00001, 0.00005, 0.00002, 0.00004, 0.00001, 0.00003, 0.00037, 
	0.00004, 0.00033, 0.00001, 0.00006, 0.00000, 0.00016, 0.00014, 0.00023, 
	0.00003, 0.00001, 0.00001, 0.00000, 0.00001, 0.00002, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 
	0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00001, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00009, 0.00006, 0.00012, 0.00010, 
	0.00004, 0.00005, 0.00011, 0.00004, 0.00009, 0.00002, 0.00002, 0.00071, 
	0.00011, 0.00068, 0.00004, 0.00006, 0.00001, 0.00169, 0.00045, 0.00019, 
	0.00001, 0.00003, 0.00003, 0.00001, 0.00007, 0.00002, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00021, 0.00003, 0.00042, 0.00068, 
	0.00077, 0.00000, 0.00004, 0.00000, 0.00001, 0.00001, 0.00004, 0.00026, 
	0.00003, 0.00048, 0.00005, 0.00011, 0.00000, 0.00021, 0.00056, 0.00020, 
	0.00001, 0.00015, 0.00000, 0.00001, 0.00000, 0.00004, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00002, 0.00006, 0.00005, 0.00002, 0.00001, 0.00002, 0.00000, 
	0.00012, 0.00001, 0.00001, 0.00020, 0.00001, 0.00006, 0.00002, 0.00001, 
	0.00000, 0.00011, 0.00007, 0.00005, 0.00004, 0.00001, 0.00000, 0.00002, 
	0.00007, 0.00002, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00002, 
	0.00001, 0.00000, 0.00000, 0.00001, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00001, 
	0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00001, 0.00000, 0.00005, 0.00000, 0.00000, 0.00002, 
	0.00001, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00001, 
	0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00005, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00002, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00002, 0.00002, 0.00003, 0.00001, 0.00001, 0.00005, 0.00003, 
	0.00006, 0.00001, 0.00005, 0.00035, 0.00002, 0.00023, 0.00000, 0.00007, 
	0.00000, 0.00062, 0.00008, 0.00029, 0.00001, 0.00005, 0.00001, 0.00001, 
	0.00027, 0.00001, 0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00003, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00001, 0.00001, 0.00000, 0.00000, 0.00001, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00018, 0.00168, 0.00002, 0.00011, 0.00028, 0.00001, 0.00003, 0.00001, 
	0.00012, 0.00000, 0.00001, 0.00028, 0.00001, 0.00007, 0.00000, 0.00001, 
	0.00000, 0.00054, 0.00019, 0.00004, 0.00000, 0.00000, 0.00001, 0.00001, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00010, 0.00000, 
	0.00000, 0.00000, 0.00009, 0.00000, 0.00000, 0.00000, 0.00014, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00015, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00002, 0.00000, 0.00006, 0.00007, 0.00005, 0.00007, 0.00002, 0.00000, 
	0.00001, 0.00001, 0.00012, 0.00016, 0.00002, 0.00048, 0.00000, 0.00001, 
	0.00000, 0.00010, 0.00018, 0.00025, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00000, 0.00005, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00003, 0.00000, 0.00001, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00002, 0.00001, 0.00001, 0.00001, 0.00005, 0.00001, 
	0.00001, 0.00001, 0.00002, 0.00000, 0.00000, 0.00020, 0.00001, 0.00000, 
	0.00001, 0.00001, 0.00000, 0.00000, 0.00003, 0.00002, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 0.00001, 0.00001, 
	0.00001, 0.00001, 0.00000, 0.00002, 0.00000, 0.00001, 0.00001, 0.00005, 
	0.00012, 0.00007, 0.00019, 0.00001, 0.00000, 0.00196, 0.00001, 0.00001, 
	0.00001, 0.00000, 0.00005, 0.00000, 0.00000, 0.00000, 0.00003, 0.00001, 
	0.00001, 0.00001, 0.00001, 0.00000, 0.00000, 0.00001, 0.00001, 0.00000, 
	0.00000, 0.00001, 0.00001, 0.00000, 0.00002, 0.00001, 0.00000, 0.00002, 
	0.00002, 0.00002, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 0.00004, 0.00000, 
	0.00000, 0.00000, 0.00011, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00003, 0.00003, 0.00002, 
	0.00006, 0.00001, 0.00001, 0.00002, 0.00003, 0.00000, 0.00002, 0.00003, 
	0.00002, 0.00002, 0.00004, 0.00004, 0.00000, 0.00002, 0.00001, 0.00005, 
	0.00002, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00001, 0.00000, 0.00003, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00007, 0.00000, 0.00000, 0.00002, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00001, 
	0.00000, 0.00001, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00004, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00002, 0.00002, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 
	0.00005, 0.00005, 0.00000, 0.00001, 0.00000, 0.00003, 0.00004, 0.00001, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00002, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00001, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00003, 0.00000, 0.00000, 0.00000, 0.00005, 0.00000, 0.00000, 0.00008, 
	0.00001, 0.00000, 0.00000, 0.00005, 0.00000, 0.00000, 0.00004, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00002, 0.00002, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00008, 
	0.00002, 0.00003, 0.00000, 0.00000, 0.00000, 0.00003, 0.00002, 0.00001, 
	0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00002, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00007, 0.00001, 0.00008, 0.00001, 
	0.00003, 0.00001, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00001, 
	0.00005, 0.00011, 0.00002, 0.00001, 0.00000, 0.00001, 0.00005, 0.00003, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00005, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 
	0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00001, 0.00001, 0.00003, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00004, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00001, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00004, 0.00000, 0.00001, 
	0.00000, 0.00001, 0.00001, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00006, 0.00000, 0.00000, 0.00000, 0.00019, 0.00000, 
	0.00000, 0.00001, 0.00002, 0.00000, 0.00000, 0.00008, 0.00000, 0.00000, 
	0.00014, 0.00000, 0.00000, 0.00018, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00001, 0.00000, 0.00003, 0.00000, 0.00000, 0.00003, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00002, 
	0.00000, 0.00000, 0.00000, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00003, 0.00001, 0.00001, 0.00001, 0.00008, 0.00000, 
	0.00001, 0.00001, 0.00003, 0.00000, 0.00000, 0.00001, 0.00001, 0.00000, 
	0.00004, 0.00001, 0.00000, 0.00017, 0.00001, 0.00000, 0.00009, 0.00001, 
	0.00001, 0.00000, 0.00001, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00004, 0.00004, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00007, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00001, 0.00001, 0.00000, 0.00000, 0.00001, 
	0.00000, 0.00001, 0.00001, 0.00000, 0.00000, 0.00001, 0.00001, 0.00000, 
	0.00001, 0.00001, 0.00000, 0.00000, 0.00001, 0.00002, 0.00000, 0.00001, 
	0.00000, 0.00017, 0.00000, 0.00000, 0.00001, 0.00001, 0.00001, 0.00000, 
	0.00000, 0.00001, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 
	0.00001, 0.00001, 0.00001, 0.00001, 0.00000, 0.00000, 0.00002, 0.00001, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00004, 0.00005, 0.00007, 0.00001, 0.00002, 0.00006, 0.00004, 
	0.00001, 0.00001, 0.00006, 0.00013, 0.00010, 0.00026, 0.00002, 0.00005, 
	0.00000, 0.00013, 0.00010, 0.00009, 0.00003, 0.00001, 0.00002, 0.00000, 
	0.00001, 0.00004, 0.00011, 0.00001, 0.00000, 0.00000, 0.00016, 0.00000, 
	0.00000, 0.00000, 0.00007, 0.00000, 0.00000, 0.00009, 0.00000, 0.00000, 
	0.00013, 0.00000, 0.00000, 0.00005, 0.00000, 0.00000, 0.00008, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00015, 0.00000, 0.00000, 0.00000, 
	0.00004, 0.00000, 0.00000, 0.00013, 0.00003, 0.00001, 0.00000, 0.00016, 
	0.00000, 0.00000, 0.00021, 0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 
	0.00003, 0.00000, 0.00000, 0.00000, 0.00001, 0.00001, 0.00010, 0.00000, 
	0.00000, 0.00000, 0.00013, 0.00000, 0.00000, 0.00000, 0.00009, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00002, 0.00007, 0.00000, 0.00000, 0.00005, 
	0.00001, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00005, 0.00001, 0.00002, 0.00003, 0.00001, 0.00001, 0.00001, 0.00001, 
	0.00000, 0.00000, 0.00001, 0.00007, 0.00004, 0.00008, 0.00001, 0.00001, 
	0.00000, 0.00019, 0.00009, 0.00003, 0.00002, 0.00001, 0.00001, 0.00003, 
	0.00001, 0.00001, 0.00008, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00008, 0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 
	0.00009, 0.00000, 0.00000, 0.00007, 0.00000, 0.00000, 0.00004, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00009, 0.00000, 0.00000, 0.00000, 
	0.00003, 0.00000, 0.00001, 0.00000, 0.00006, 0.00000, 0.00000, 0.00002, 
	0.00000, 0.00000, 0.00005, 0.00000, 0.00000, 0.00006, 0.00000, 0.00000, 
	0.00004, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00005, 0.00000, 
	0.00000, 0.00000, 0.00006, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00013, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00001, 0.00001, 0.00001, 0.00001, 0.00001, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00001, 0.00003, 0.00019, 0.00000, 0.00003, 
	0.00000, 0.00001, 0.00002, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00001, 0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00004, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00001, 
	0.00000, 0.00001, 0.00002, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00009, 0.00000, 
	0.00000, 0.00000, 0.00031, 0.00000, 0.00000, 0.00000, 0.00020, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00011, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00022, 0.00001, 0.00001, 0.00000, 0.00015, 0.00000, 0.00000, 0.00000, 
	0.00005, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00015, 0.00004, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00011, 0.00000, 0.00003, 0.00003, 0.00016, 0.00000, 
	0.00001, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 
	0.00006, 0.00000, 0.00000, 0.00000, 0.00001, 0.00002, 0.00002, 0.00000, 
	0.00000, 0.00001, 0.00001, 0.00000, 0.00001, 0.00002, 0.00001, 0.00002, 
	0.00000, 0.00007, 0.00006, 0.00001, 0.00001, 0.00000, 0.00003, 0.00003, 
	0.00002, 0.00019, 0.00002, 0.00003, 0.00000, 0.00009, 0.00004, 0.00006, 
	0.00158, 0.00001, 0.00001, 0.00000, 0.00001, 0.00000, 0.00011, 0.00000, 
	0.00001, 0.00000, 0.00014, 0.00000, 0.00000, 0.00004, 0.00006, 0.00000, 
	0.00000, 0.00005, 0.00000, 0.00001, 0.00012, 0.00000, 0.00000, 0.00012, 
	0.00001, 0.00004, 0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00005, 0.00000, 0.00000, 0.00000, 0.00014, 0.00000, 
	0.00000, 0.00000, 0.00008, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00006, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00008, 0.00002, 0.00007, 0.00001, 
	0.00014, 0.00001, 0.00001, 0.00015, 0.00013, 0.00000, 0.00002, 0.00003, 
	0.00003, 0.00002, 0.00009, 0.00007, 0.00001, 0.00001, 0.00003, 0.00043, 
	0.00006, 0.00000, 0.00002, 0.00001, 0.00001, 0.00000, 0.00005, 0.00000, 
	0.00000, 0.00000, 0.00013, 0.00000, 0.00000, 0.00011, 0.00009, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00011, 0.00000, 0.00000, 0.00011, 
	0.00000, 0.00000, 0.00010, 0.00002, 0.00001, 0.00000, 0.00001, 0.00000, 
	0.00002, 0.00001, 0.00001, 0.00001, 0.00001, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00003, 0.00001, 0.00003, 0.00011, 0.00000, 0.00002, 
	0.00000, 0.00003, 0.00004, 0.00001, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00001, 0.00002, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00006, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00007, 0.00000, 0.00000, 0.00000, 
	0.00009, 0.00000, 0.00000, 0.00003, 0.00006, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00014, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00004, 0.00004, 0.00003, 0.00005, 
	0.00001, 0.00001, 0.00002, 0.00003, 0.00004, 0.00001, 0.00004, 0.00004, 
	0.00006, 0.00010, 0.00001, 0.00005, 0.00000, 0.00018, 0.00003, 0.00004, 
	0.00001, 0.00001, 0.00002, 0.00000, 0.00001, 0.00001, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00003, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 
	0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00001, 0.00003, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00002, 0.00003, 0.00004, 
	0.00003, 0.00001, 0.00001, 0.00001, 0.00008, 0.00000, 0.00002, 0.00005, 
	0.00003, 0.00018, 0.00001, 0.00003, 0.00000, 0.00017, 0.00004, 0.00009, 
	0.00002, 0.00001, 0.00001, 0.00001, 0.00001, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00005, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00005, 0.00001, 0.00002, 0.00001, 
	0.00006, 0.00001, 0.00003, 0.00000, 0.00001, 0.00001, 0.00003, 0.00006, 
	0.00003, 0.00037, 0.00007, 0.00004, 0.00000, 0.00001, 0.00002, 0.00002, 
	0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00010, 0.00000, 
	0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00004, 0.00000, 0.00000, 0.00000, 
	0.00002, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00004, 0.00000, 
	0.00000, 0.00000, 0.00006, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00001, 0.00001, 0.00001, 0.00001, 0.00001, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00002, 0.00002, 0.00031, 0.00012, 0.00001, 
	0.00000, 0.00004, 0.00001, 0.00001, 0.00001, 0.00001, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00001, 0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00001, 
	0.00000, 0.00000, 0.00000, 0.00001, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00001, 0.00001, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00001, 0.00001, 0.00000, 
	0.00002, 0.00000, 0.00001, 0.00001, 0.00001, 0.00000, 0.00003, 0.00002, 
	0.00002, 0.00002, 0.00001, 0.00001, 0.00000, 0.00003, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 0.00000, 0.00000, 
	0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00002, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 
	0.00000, 0.00000, 0.00000, 0.00000, 0.00001, 0.00001, 0.00002, 0.00001, 
	0.00000, 0.00001, 0.00001, 0.00000, 0.00000, 0.00000, 0.00001, 0.00001, 
	0.00001, 0.00001, 0.00001, 0.00001, 0.00000, 0.00000, 0.00002, 0.00001, 
	0.00000, 0.00000, 0.00001, 0.00000, 0.00000, 0.00000, 0.00007, 0.00001, 
	0.00001, 0.00000, 0.00003, 0.00000, 0.00000, 0.00000, 0.00003, 0.00000, 
	0.00000, 0.00004, 0.00001, 0.00000, 0.00002, 0.00001, 0.00000, 0.00000, 
	0.00001, 0.00001, 0.00001, 0.00000, 0.00000, 0.00000, 0.00002, 0.00001
};

/*
Rule *rules[] = {
    &rule31738,
    NULL
};
*/

